/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCUtils {
    private static final Log log = LogFactory.getLog(JDBCUtils.class);
    public static final int MAX_TRIES = 5;

    public static <V> V callWithRetry(Callable<V> callable) throws SQLException {
        int tryNo = 1;
        while (true) {
            try {
                return callable.call();
            }
            catch (SQLException e) {
                if (tryNo >= 5) {
                    throw e;
                }
                int errorCode = e.getErrorCode();
                if (errorCode != 12516 && errorCode != 12519) {
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Connections open too fast, retrying in %ds: %s", tryNo, e.getMessage().replace("\n", " ")));
                }
                try {
                    Thread.sleep(1000 * tryNo);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException(e);
            }
            ++tryNo;
        }
    }

    public static Connection getConnection(final String url, final String user, final String password) throws SQLException {
        return JDBCUtils.callWithRetry(new Callable<Connection>(){

            @Override
            public Connection call() throws SQLException {
                return DriverManager.getConnection(url, user, password);
            }
        });
    }

    public static Connection getConnection(final DataSource dataSource) throws SQLException {
        return JDBCUtils.callWithRetry(new Callable<Connection>(){

            @Override
            public Connection call() throws SQLException {
                return dataSource.getConnection();
            }
        });
    }

    public static XAConnection getXAConnection(final XADataSource xaDataSource) throws SQLException {
        return JDBCUtils.callWithRetry(new Callable<XAConnection>(){

            @Override
            public XAConnection call() throws SQLException {
                return xaDataSource.getXAConnection();
            }
        });
    }
}

