/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.AbstractRunner;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class GraphRunner
extends AbstractRunner
implements ElementRunner,
Serializable {
    private static final Log log = LogFactory.getLog(GraphRunner.class);
    public static final int MAX_LOOPS = 100;

    @Override
    public void run(CoreSession session, DocumentRouteElement element, Map<String, Serializable> map) {
        try {
            GraphRoute graph = (GraphRoute)element;
            element.setRunning(session);
            if (map != null) {
                graph.setVariables(map);
            }
            this.runGraph(session, element, graph.getStartNode());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void run(CoreSession session, DocumentRouteElement element) {
        this.run(session, element, null);
    }

    @Override
    public void resume(CoreSession session, DocumentRouteElement element, String nodeId, String taskId, Map<String, Object> varData, String status) {
        try {
            boolean forceResume;
            GraphNode node;
            GraphRoute graph = (GraphRoute)element;
            Task task = null;
            if (taskId == null) {
                if (nodeId == null) {
                    throw new DocumentRouteException("nodeId and taskId both missing");
                }
            } else {
                DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
                task = (Task)taskDoc.getAdapter(Task.class);
                if (task == null) {
                    throw new DocumentRouteException("Invalid taskId: " + taskId);
                }
                if (nodeId == null && StringUtils.isEmpty((String)(nodeId = task.getVariable("nodeId")))) {
                    throw new DocumentRouteException("No nodeId found on task: " + taskId);
                }
            }
            if ((node = graph.getNode(nodeId)) == null) {
                throw new DocumentRouteException("Invalid nodeId: " + nodeId);
            }
            boolean bl = forceResume = varData != null && varData.get("_FORCE_RESUME_") != null && (Boolean)varData.get("_FORCE_RESUME_") != false;
            if (forceResume && node.getState() != GraphNode.State.SUSPENDED && node.getState() != GraphNode.State.WAITING) {
                throw new DocumentRouteException("Cannot force resume on non-suspended or non-waiting node: " + node);
            }
            if (!forceResume && node.getState() != GraphNode.State.SUSPENDED) {
                throw new DocumentRouteException("Cannot resume on non-suspended node: " + node);
            }
            node.setAllVariables(varData);
            if (StringUtils.isNotEmpty((String)status)) {
                node.setButton(status);
            }
            if (task != null) {
                this.finishTask(session, graph, node, task, false, status);
            } else {
                node.cancelTasks();
            }
            if (node.hasOpenTasks()) {
                log.info((Object)("Node " + node.getId() + "has open tasks, the workflow can not be resumed for now."));
                if (varData != null && varData.get("NodeVariables") != null && ((Map)varData.get("NodeVariables")).containsKey("comment")) {
                    node.setVariable("comment", "");
                }
                return;
            }
            this.runGraph(session, element, node);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void cancel(CoreSession session, DocumentRouteElement element) {
        super.cancel(session, element);
        if (!(element instanceof GraphRoute)) {
            return;
        }
        GraphRoute graph = (GraphRoute)element;
        try {
            for (GraphNode node : graph.getNodes()) {
                node.cancelTasks();
                node.cancelSubRoute();
            }
        }
        catch (DocumentRouteException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void runGraph(CoreSession session, DocumentRouteElement element, GraphNode initialNode) throws DocumentRouteException, ClientException {
        GraphRoute graph = (GraphRoute)element;
        LinkedList<GraphNode> pendingSubRoutes = new LinkedList<GraphNode>();
        LinkedList<GraphNode> pendingNodes = new LinkedList<GraphNode>();
        pendingNodes.add(initialNode);
        boolean done = false;
        int count = 0;
        while (!pendingNodes.isEmpty()) {
            GraphNode node = (GraphNode)pendingNodes.pop();
            if (++count > 100) {
                throw new DocumentRouteException("Execution is looping, node: " + node);
            }
            GraphNode.State jump = null;
            switch (node.getState()) {
                case READY: {
                    log.debug((Object)("Doing node " + node));
                    if (node.isMerge()) {
                        jump = GraphNode.State.WAITING;
                        break;
                    }
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case WAITING: {
                    if (!node.canMerge()) break;
                    this.recursiveCancelInput(graph, node, pendingNodes);
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case RUNNING_INPUT: {
                    node.starting();
                    node.executeChain(node.getInputChain());
                    if (node.hasTask() || node.hasMultipleTasks()) {
                        this.createTask(session, graph, node);
                        node.setState(GraphNode.State.SUSPENDED);
                    }
                    if (node.hasSubRoute()) {
                        if (!pendingSubRoutes.contains(node)) {
                            pendingSubRoutes.add(node);
                        }
                        node.setState(GraphNode.State.SUSPENDED);
                    }
                    if (node.getState() == GraphNode.State.SUSPENDED) break;
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case SUSPENDED: {
                    if (node != initialNode) {
                        throw new DocumentRouteException("Executing unexpected SUSPENDED state");
                    }
                    NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
                    String actor = principal.getActingUser();
                    node.setLastActor(actor);
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case RUNNING_OUTPUT: {
                    node.executeChain(node.getOutputChain());
                    List<GraphNode.Transition> trueTrans = node.evaluateTransitions();
                    node.ending();
                    node.setState(GraphNode.State.READY);
                    if (node.isStop()) {
                        if (!pendingNodes.isEmpty()) {
                            throw new DocumentRouteException(String.format("Route %s stopped with still pending nodes: %s", graph, pendingNodes));
                        }
                        done = true;
                        break;
                    }
                    if (trueTrans.isEmpty()) {
                        throw new DocumentRouteException("No transition evaluated to true from node " + node);
                    }
                    for (GraphNode.Transition t : trueTrans) {
                        node.executeTransitionChain(t);
                        GraphNode target = graph.getNode(t.target);
                        if (pendingNodes.contains(target)) continue;
                        pendingNodes.add(target);
                    }
                    break;
                }
            }
            if (jump == null) continue;
            node.setState(jump);
            --count;
            pendingNodes.addFirst(node);
        }
        if (done) {
            element.setDone(session);
            if (graph.hasParentRoute()) {
                graph.resumeParentRoute(session);
            }
        }
        for (GraphNode node : pendingSubRoutes) {
            DocumentRoute subRoute = node.startSubRoute();
        }
        session.save();
    }

    protected void recursiveCancelInput(GraphRoute graph, GraphNode originalNode, LinkedList<GraphNode> pendingNodes) {
        LinkedList<GraphNode> todo = new LinkedList<GraphNode>();
        todo.add(originalNode);
        HashSet<String> done = new HashSet<String>();
        while (!todo.isEmpty()) {
            GraphNode node = (GraphNode)todo.pop();
            done.add(node.getId());
            for (GraphNode.Transition t : node.getInputTransitions()) {
                GraphNode source;
                if (t.loop || done.contains((source = t.source).getId())) continue;
                source.setCanceled();
                GraphNode.State state = source.getState();
                source.setState(GraphNode.State.READY);
                pendingNodes.remove(node);
                if (state == GraphNode.State.SUSPENDED) {
                    source.cancelTasks();
                    continue;
                }
                todo.add(source);
            }
        }
    }

    protected void createTask(CoreSession session, GraphRoute graph, GraphNode node) throws DocumentRouteException {
        DocumentRouteElement routeInstance = (DocumentRouteElement)graph;
        HashMap<String, String> taskVariables = new HashMap<String, String>();
        taskVariables.put("routeInstanceDocId", routeInstance.getDocument().getId());
        taskVariables.put("nodeId", node.getId());
        taskVariables.put("document.routing.step", node.getDocument().getId());
        String taskNotiftemplate = node.getTaskNotificationTemplate();
        if (!StringUtils.isEmpty((String)taskNotiftemplate)) {
            taskVariables.put("taskNotificationTemplate", taskNotiftemplate);
        } else {
            taskVariables.put("disableNotificationService", "true");
        }
        LinkedHashSet<String> actors = new LinkedHashSet<String>();
        actors.addAll(node.evaluateTaskAssignees());
        actors.addAll(node.getTaskAssignees());
        Date dueDate = node.computeTaskDueDate();
        DocumentModelList docs = graph.getAttachedDocumentModels();
        try {
            TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
            DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
            List tasks = taskService.createTask(session, (NuxeoPrincipal)session.getPrincipal(), (List)docs, node.getTaskDocType(), node.getDocument().getTitle(), node.getId(), routeInstance.getDocument().getId(), new ArrayList(actors), node.hasMultipleTasks(), node.getTaskDirective(), null, dueDate, taskVariables, null, node.getWorkflowContextualInfo(session, true));
            routing.makeRoutingTasks(session, tasks);
            for (Task task : tasks) {
                node.addTaskInfo(task.getId());
            }
            String taskAssigneesPermission = node.getTaskAssigneesPermission();
            if (StringUtils.isEmpty((String)taskAssigneesPermission)) {
                return;
            }
            for (Task task : tasks) {
                routing.grantPermissionToTaskAssignees(session, taskAssigneesPermission, (List)docs, task);
            }
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Can not create task", (Throwable)e);
        }
    }

    protected void finishTask(CoreSession session, GraphRoute graph, GraphNode node, Task task, boolean delete) throws DocumentRouteException {
        this.finishTask(session, graph, node, task, delete, null);
    }

    protected void finishTask(CoreSession session, GraphRoute graph, GraphNode node, Task task, boolean delete, String status) throws DocumentRouteException {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        DocumentModelList docs = graph.getAttachedDocumentModels();
        try {
            List comments;
            routing.removePermissionsForTaskActors(session, (List)docs, task);
            if (delete) {
                session.removeDocument((DocumentRef)new IdRef(task.getId()));
            }
            String comment = (comments = task.getComments()).size() > 0 ? ((TaskComment)comments.get(comments.size() - 1)).getText() : "";
            NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
            String actor = principal.getActingUser();
            node.updateTaskInfo(task.getId(), true, status, actor, comment);
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Cannot finish task", (Throwable)e);
        }
    }
}

