/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.persistence;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.service.extension.ExportedZipImporter;
import org.nuxeo.ecm.platform.types.TypeManager;

public class RouteModelsZipImporter
extends ExportedZipImporter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RouteModelsZipImporter.class);

    public DocumentModel create(CoreSession session, Blob content, String path, boolean overwrite, String filename, TypeManager typeService) throws ClientException, IOException {
        PathRef resultingRef;
        DocumentModel target;
        File tmp = File.createTempFile("xml-importer", null);
        content.transferTo(tmp);
        ZipFile zip = RouteModelsZipImporter.getArchiveFileIfValid((File)tmp);
        if (zip == null) {
            tmp.delete();
            return null;
        }
        boolean overWrite = false;
        NuxeoArchiveReader reader = new NuxeoArchiveReader(tmp);
        ExportedDocument root = reader.read();
        PathRef rootRef = new PathRef(path, root.getPath().toString());
        ACP currentRouteModelACP = null;
        if (session.exists((DocumentRef)rootRef) && (target = session.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(path))) {
            overWrite = true;
            DocumentModel routeModel = session.getDocument((DocumentRef)rootRef);
            currentRouteModelACP = routeModel.getACP();
            session.removeDocument((DocumentRef)rootRef);
        }
        DocumentModelWriter writer = new DocumentModelWriter(session, path, 10);
        reader.close();
        reader = new NuxeoArchiveReader(tmp);
        if (overwrite && overWrite) {
            resultingRef = rootRef;
        } else {
            String rootName = root.getPath().lastSegment();
            resultingRef = new PathRef(path, rootName);
        }
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Can not import route model", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not import route model", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Can not import route model", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            reader.close();
            writer.close();
        }
        tmp.delete();
        DocumentModel newRouteModel = session.getDocument((DocumentRef)resultingRef);
        if (currentRouteModelACP != null && overwrite && overWrite) {
            newRouteModel.setACP(currentRouteModelACP, true);
        }
        return session.saveDocument(newRouteModel);
    }
}

