/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;

public final class SequenceIterationStatus
implements Serializable {
    private static final long serialVersionUID = 1968212566967489719L;
    private Integer begin;
    private Integer count;
    private Integer end;
    private int index;
    private Integer rowCount;
    private boolean first;
    private boolean last;
    private boolean even;

    public SequenceIterationStatus(Integer begin, Integer end, int index, Integer rowCount) {
        int iBegin = begin != null ? begin : 0;
        int iRowCountEnd = rowCount != null ? rowCount - 1 : Integer.MAX_VALUE;
        int iEnd = end != null ? end : iRowCountEnd;
        int iLastIdx = Math.min(iEnd, iRowCountEnd);
        this.begin = begin;
        this.end = iEnd;
        this.index = index;
        this.rowCount = rowCount;
        this.first = index == iBegin;
        this.last = index >= iLastIdx;
        this.count = index - iBegin + 1;
        this.even = this.count % 2 == 0;
    }

    public Integer getBegin() {
        return this.begin;
    }

    public int getCount() {
        return this.count;
    }

    public Object getCurrent() {
        return null;
    }

    public Integer getEnd() {
        return this.end;
    }

    public int getIndex() {
        return this.index;
    }

    public Integer getStep() {
        return 1;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public boolean isEven() {
        return this.even;
    }

    public boolean isOdd() {
        return !this.isEven();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("begin= " + this.begin);
        sb.append(", end= " + this.end);
        sb.append(", index= " + this.index);
        sb.append(", count= " + this.count);
        sb.append(", first= " + this.first);
        sb.append(", last= " + this.last);
        sb.append(", even= " + this.even);
        sb.append(", rowCount= " + this.rowCount);
        return sb.toString();
    }
}

