/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.attribute;

import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.Description;
import org.richfaces.cdk.annotations.EventName;

public interface AjaxProps {
    @Attribute(description=@Description(value="IDs of components that will participate in the \"execute\" portion of the Request Processing Lifecycle. Can be a single ID, a space or comma separated list of IDs, or an EL Expression evaluating to an array or Collection. Any of the keywords \"@this\", \"@form\", \"@all\", \"@none\", \"@region\" may be specified in the identifier list. Some components make use of additional keywords"))
    public Object getExecute();

    @Attribute(description=@Description(value="IDs of components that will participate in the \"render\" portion of the Request Processing Lifecycle. Can be a single ID, a space or comma separated list of Id's, or an EL Expression evaluating to an array or Collection. Any of the keywords \"@this\", \"@form\", \"@all\", \"@none\", \"@region\" may be specified in the identifier list. Some components make use of additional keywords"))
    public Object getRender();

    @Attribute(defaultValue="false", description=@Description(value="If \"true\", render only those ids specified in the \"render\" attribute, forgoing the render of the auto-rendered panels"))
    public boolean isLimitRender();

    @Attribute(description=@Description(value="Name of the request status component that will indicate the status of the Ajax request"))
    public String getStatus();

    @Attribute(description=@Description(value="Serialized (on default with JSON) data passed to the client by a developer on an AJAX request. It's accessible via \"event.data\" syntax. Both primitive types and complex types such as arrays and collections can be serialized and used with data"))
    public Object getData();

    @Attribute(events={@EventName(value="begin")}, description=@Description(value="The client-side script method to be called before an ajax request."))
    public String getOnbegin();

    @Attribute(events={@EventName(value="beforedomupdate")}, description=@Description(value="The client-side script method to be called after the ajax response comes back, but before the DOM is updated"))
    public String getOnbeforedomupdate();

    @Attribute(events={@EventName(value="complete")}, description=@Description(value="The client-side script method to be called after the DOM is updated"))
    public String getOncomplete();
}

