/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.monitoring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.ProbeInfo;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="monitoringAction")
@Scope(value=ScopeType.PAGE)
public class MonitoringActionBean
implements Serializable {
    public static final String NUXEO_SERVER_IS_ACTIVE = "nuxeoServiceIsActive";
    public static final String NUXEO_SERVER_MESSAGE = "org.nuxeo.ecm.deactivatedServerMessage";
    protected static final Log log = LogFactory.getLog(MonitoringActionBean.class);
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected NuxeoPrincipal currentNuxeoPrincipal;
    @RequestParameter(value="serviceIdentifier")
    protected String statusIdentifierToEdit;
    @RequestParameter(value="probeName")
    protected String probeName;
    protected String newStatusMessage;
    protected String newStatusValue;
    protected AdministrativeStatus editableStatus;

    public AdministrativeStatus getEditableStatus() {
        return this.editableStatus;
    }

    protected AdministrativeStatusManager getStatusManager() {
        return (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
    }

    public List<String> listNuxeoInstances() {
        return ((GlobalAdministrativeStatusManager)Framework.getLocalService(GlobalAdministrativeStatusManager.class)).listInstanceIds();
    }

    @Factory(value="isMultiServerInstallation", scope=ScopeType.EVENT)
    public boolean isMultiServerInstallation() {
        return this.listNuxeoInstances().size() > 1;
    }

    public List<AdministrativeStatus> getAdministrativeStatuses() {
        List statuses = this.getStatusManager().getAllStatuses();
        for (AdministrativeStatus status : statuses) {
            log.info((Object)("Status : " + status.getLabel() + "=>" + status.getState()));
        }
        return statuses;
    }

    public void editStatus() {
        this.editableStatus = this.getStatusManager().getStatus(this.statusIdentifierToEdit);
        this.newStatusMessage = this.editableStatus.getMessage();
        this.newStatusValue = this.editableStatus.isActive() ? "passive" : "active";
    }

    public void saveStatus() {
        if (this.editableStatus != null) {
            String serviceId = this.editableStatus.getServiceIdentifier();
            this.changeStatus(serviceId, this.newStatusMessage, this.newStatusValue);
            this.resetEdit();
        }
    }

    public void cancelEdit() {
        this.resetEdit();
    }

    public void resetEdit() {
        this.editableStatus = null;
        this.newStatusMessage = null;
        this.newStatusValue = null;
    }

    public void changeStatus(String serviceId, String message, String state) {
        this.getStatusManager().setStatus(serviceId, state, message, this.currentNuxeoPrincipal.getName());
    }

    public List<ProbeInfo> getProbeInfos() {
        ArrayList<ProbeInfo> infos = new ArrayList<ProbeInfo>();
        ProbeManager pm = (ProbeManager)Framework.getLocalService(ProbeManager.class);
        infos.addAll(pm.getAllProbeInfos());
        return infos;
    }

    public void runProbe() {
        ProbeManager pm = (ProbeManager)Framework.getLocalService(ProbeManager.class);
        pm.runProbe(this.probeName);
    }

    public void runAllProbes() {
        ProbeManager pm = (ProbeManager)Framework.getLocalService(ProbeManager.class);
        pm.runAllProbes();
    }

    public String getNewStatusMessage() {
        return this.newStatusMessage;
    }

    public void setNewStatusMessage(String newStatusMessage) {
        this.newStatusMessage = newStatusMessage;
    }

    public String getNewStatusValue() {
        return this.newStatusValue;
    }

    public void setNewStatusValue(String newStatusValue) {
        this.newStatusValue = newStatusValue;
    }
}

