/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.artofsolving.jodconverter.office.ManagedOfficeProcess;
import org.artofsolving.jodconverter.office.NamedThreadFactory;
import org.artofsolving.jodconverter.office.OfficeConnection;
import org.artofsolving.jodconverter.office.OfficeConnectionEvent;
import org.artofsolving.jodconverter.office.OfficeConnectionEventListener;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.artofsolving.jodconverter.office.PooledOfficeManagerSettings;
import org.artofsolving.jodconverter.office.SuspendableThreadPoolExecutor;
import org.artofsolving.jodconverter.office.UnoUrl;

class PooledOfficeManager
implements OfficeManager {
    private final PooledOfficeManagerSettings settings;
    private final ManagedOfficeProcess managedOfficeProcess;
    private final SuspendableThreadPoolExecutor taskExecutor;
    private volatile boolean stopping = false;
    private int taskCount;
    private Future<?> currentTask;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private OfficeConnectionEventListener connectionEventListener = new OfficeConnectionEventListener(){

        public void connected(OfficeConnectionEvent event) {
            PooledOfficeManager.this.taskCount = 0;
            PooledOfficeManager.this.taskExecutor.setAvailable(true);
        }

        public void disconnected(OfficeConnectionEvent event) {
            PooledOfficeManager.this.taskExecutor.setAvailable(false);
            if (PooledOfficeManager.this.stopping) {
                PooledOfficeManager.this.stopping = false;
            } else {
                PooledOfficeManager.this.logger.warning("connection lost unexpectedly; attempting restart");
                if (PooledOfficeManager.this.currentTask != null) {
                    PooledOfficeManager.this.currentTask.cancel(true);
                }
                PooledOfficeManager.this.managedOfficeProcess.restartDueToLostConnection();
            }
        }
    };

    public PooledOfficeManager(UnoUrl unoUrl) {
        this(new PooledOfficeManagerSettings(unoUrl));
    }

    public PooledOfficeManager(PooledOfficeManagerSettings settings) {
        this.settings = settings;
        this.managedOfficeProcess = new ManagedOfficeProcess(settings);
        this.managedOfficeProcess.getConnection().addConnectionEventListener(this.connectionEventListener);
        this.taskExecutor = new SuspendableThreadPoolExecutor(new NamedThreadFactory("OfficeTaskThread"));
    }

    public void execute(final OfficeTask task) throws OfficeException {
        Future<?> futureTask = this.taskExecutor.submit(new Runnable(){

            public void run() {
                if (PooledOfficeManager.this.settings.getMaxTasksPerProcess() > 0 && ++PooledOfficeManager.this.taskCount == PooledOfficeManager.this.settings.getMaxTasksPerProcess() + 1) {
                    PooledOfficeManager.this.logger.info(String.format("reached limit of %d maxTasksPerProcess: restarting", PooledOfficeManager.this.settings.getMaxTasksPerProcess()));
                    PooledOfficeManager.this.taskExecutor.setAvailable(false);
                    PooledOfficeManager.this.stopping = true;
                    PooledOfficeManager.this.managedOfficeProcess.restartAndWait();
                }
                task.execute(PooledOfficeManager.this.managedOfficeProcess.getConnection());
            }
        });
        this.currentTask = futureTask;
        try {
            futureTask.get(this.settings.getTaskExecutionTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            this.managedOfficeProcess.restartDueToTaskTimeout();
            throw new OfficeException("task did not complete within timeout", timeoutException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OfficeException) {
                throw (OfficeException)executionException.getCause();
            }
            throw new OfficeException("task failed", executionException.getCause());
        }
        catch (Exception exception) {
            throw new OfficeException("task failed", exception);
        }
    }

    public void start() throws OfficeException {
        this.managedOfficeProcess.startAndWait();
    }

    public void stop() throws OfficeException {
        this.taskExecutor.setAvailable(false);
        this.stopping = true;
        this.taskExecutor.shutdownNow();
        this.managedOfficeProcess.stopAndWait();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nPooledOfficeManager Settings :");
        sb.append(this.settings.toString());
        sb.append("\nManaged Office Process :");
        sb.append(this.managedOfficeProcess.toString());
        return sb.toString();
    }

    public OfficeConnection[] getConnection() {
        OfficeConnection[] result = new OfficeConnection[]{this.managedOfficeProcess.getConnection()};
        return result;
    }
}

