/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

@Name(value="authorizedApplicationsActions")
@Scope(value=ScopeType.CONVERSATION)
public class AuthorizedApplicationsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In
    protected NuxeoPrincipal currentUser;
    protected DirectoryService directoryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentModel> getAuthorizedApplications() throws ClientException {
        DirectoryService directoryService = this.getDirectoryService();
        try (Session session = directoryService.open("oauthTokens");){
            Map<String, Serializable> queryFilter = this.getQueryFilter();
            Set emptySet = Collections.emptySet();
            DocumentModelList documentModelList = session.query(queryFilter, emptySet, null, true);
            return documentModelList;
        }
    }

    protected DirectoryService getDirectoryService() throws ClientException {
        try {
            if (this.directoryService == null) {
                this.directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            }
            return this.directoryService;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected Map<String, Serializable> getQueryFilter() {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("clientToken", new Integer(0));
        filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(String id) throws ClientException {
        DirectoryService directoryService = this.getDirectoryService();
        try (Session session = directoryService.open("oauthTokens");){
            session.deleteEntry(id);
        }
    }
}

