/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.ActionFilter;

public class ActionFilterRegistry
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionFilterRegistry.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, ActionFilter> filters = new HashMap<String, ActionFilter>();

    public synchronized void addFilter(ActionFilter filter) {
        String id = filter.getId();
        if (log.isDebugEnabled()) {
            if (this.filters.containsKey(id)) {
                log.debug((Object)("Overriding action filter: " + id));
            } else {
                log.debug((Object)("Registering action filter: " + id));
            }
        }
        this.filters.put(id, filter);
    }

    public synchronized ActionFilter removeFilter(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-Registering action filter: " + id));
        }
        return this.filters.remove(id);
    }

    public synchronized Collection<ActionFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters.values());
    }

    public synchronized ActionFilter getFilter(String id) {
        return this.filters.get(id);
    }
}

