/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderContributionRegistry;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderDescriptor;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ServiceProviderRegistryImpl
extends DefaultComponent
implements OAuth2ServiceProviderRegistry {
    protected static final Log log = LogFactory.getLog(OAuth2ServiceProviderRegistryImpl.class);
    public static final String PROVIDER_EP = "providers";
    public static final String DIRECTORY_NAME = "oauth2ServiceProviders";
    public static final String SCHEMA = "oauth2ServiceProvider";
    protected OAuth2ServiceProviderContributionRegistry registry = new OAuth2ServiceProviderContributionRegistry();

    @Override
    public OAuth2ServiceProvider getProvider(String serviceName) {
        try {
            if (StringUtils.isBlank((String)serviceName)) {
                log.warn((Object)"Can not find provider without a serviceName!");
                return null;
            }
            HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
            filter.put("serviceName", (Serializable)((Object)serviceName));
            List<DocumentModel> providers = this.queryProviders(filter, 1);
            return providers.isEmpty() ? null : this.buildProvider(providers.get(0));
        }
        catch (DirectoryException e) {
            log.error((Object)"Unable to read provider from Directory backend", (Throwable)e);
            return null;
        }
    }

    @Override
    public OAuth2ServiceProvider addProvider(String serviceName, String description, String tokenServerURL, String authorizationServerURL, String clientId, String clientSecret, List<String> scopes) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel creationEntry = BaseSession.createEntryModel(null, (String)SCHEMA, null, null);
            DocumentModel entry = session.createEntry(creationEntry);
            entry.setProperty(SCHEMA, "serviceName", (Object)serviceName);
            entry.setProperty(SCHEMA, "description", (Object)description);
            entry.setProperty(SCHEMA, "authorizationServerURL", (Object)authorizationServerURL);
            entry.setProperty(SCHEMA, "tokenServerURL", (Object)tokenServerURL);
            entry.setProperty(SCHEMA, "clientId", (Object)clientId);
            entry.setProperty(SCHEMA, "clientSecret", (Object)clientSecret);
            entry.setProperty(SCHEMA, "scopes", (Object)StringUtils.join(scopes, (String)","));
            boolean enabled = clientId != null && clientSecret != null;
            entry.setProperty(SCHEMA, "enabled", (Object)enabled);
            if (!enabled) {
                log.info((Object)("OAuth2 provider for " + serviceName + " is disabled because clientId and/or clientSecret are empty"));
            }
            session.updateEntry(entry);
            OAuth2ServiceProvider oAuth2ServiceProvider = this.getProvider(serviceName);
            return oAuth2ServiceProvider;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<DocumentModel> queryProviders(Map<String, Serializable> filter, int limit) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            Set fulltext = Collections.emptySet();
            Map orderBy = Collections.emptyMap();
            DocumentModelList documentModelList = session.query(filter, fulltext, orderBy, true, limit, 0);
            return documentModelList;
        }
        catch (DirectoryException e) {
            log.error((Object)"Error while fetching provider directory", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected OAuth2ServiceProvider buildProvider(DocumentModel entry) {
        String serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        OAuth2ServiceProvider provider = this.registry.getProvider(serviceName);
        if (provider == null) {
            provider = new NuxeoOAuth2ServiceProvider();
            provider.setServiceName(serviceName);
        }
        provider.setId((Long)entry.getProperty(SCHEMA, "id"));
        provider.setAuthorizationServerURL((String)entry.getProperty(SCHEMA, "authorizationServerURL"));
        provider.setTokenServerURL((String)entry.getProperty(SCHEMA, "tokenServerURL"));
        provider.setClientId((String)entry.getProperty(SCHEMA, "clientId"));
        provider.setClientSecret((String)entry.getProperty(SCHEMA, "clientSecret"));
        String scopes = (String)entry.getProperty(SCHEMA, "scopes");
        provider.setScopes(StringUtils.split((String)scopes, (String)","));
        provider.setEnabled((Boolean)entry.getProperty(SCHEMA, "enabled"));
        return provider;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            OAuth2ServiceProviderDescriptor provider = (OAuth2ServiceProviderDescriptor)contribution;
            log.info((Object)("OAuth2 provider for " + provider.getName() + " will be registered at application startup"));
            this.registry.addContribution(provider);
        }
    }

    public void applicationStarted(ComponentContext context) {
        super.applicationStarted(context);
        this.registerCustomProviders();
    }

    protected void registerCustomProviders() {
        for (OAuth2ServiceProviderDescriptor provider : this.registry.getContribs()) {
            if (this.getProvider(provider.getName()) == null) {
                this.addProvider(provider.getName(), provider.getDescription(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getClientId(), provider.getClientSecret(), Arrays.asList(provider.getScopes()));
                continue;
            }
            log.info((Object)("Provider " + provider.getName() + " is already in the Database, XML contribution  won't overwrite it"));
        }
    }
}

