/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.CharUtils;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;

public abstract class ExpressionEvaluator {
    public static final String NXQL_ECM_ANCESTOR_IDS = "ecm:__ancestorIds";
    public static final String NXQL_ECM_PATH = "ecm:__path";
    public static final String NXQL_ECM_READ_ACL = "ecm:__read_acl";
    public final PathResolver pathResolver;
    public final Set<String> principals;

    public ExpressionEvaluator(PathResolver pathResolver, String[] principals) {
        this.pathResolver = pathResolver;
        this.principals = principals == null ? null : new HashSet<String>(Arrays.asList(principals));
    }

    public Object walkExpression(Expression expr) {
        String name;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        String string = name = lvalue instanceof Reference ? ((Reference)lvalue).name : null;
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if ("ecm:ancestorId".equals(name)) {
            return this.walkAncestorId(op, rvalue);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue);
        }
        if (op == Operator.NOTEQ) {
            return this.walkNotEq(lvalue, rvalue);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND) {
            if (expr instanceof MultiExpression) {
                return this.walkMultiExpression((MultiExpression)expr);
            }
            return this.walkAnd(lvalue, rvalue);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.OR) {
            return this.walkOr(lvalue, rvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkIsNull(lvalue);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkIsNotNull(lvalue);
        }
        if (op == Operator.BETWEEN) {
            return this.walkBetween(lvalue, rvalue, true);
        }
        if (op == Operator.NOTBETWEEN) {
            return this.walkBetween(lvalue, rvalue, false);
        }
        throw new QueryParseException("Unknown operator: " + op);
    }

    protected Boolean walkEcmPath(Operator op, Operand rvalue) {
        String id;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((id = this.pathResolver.getIdForPath(path)) == null) {
            return Boolean.FALSE;
        }
        Boolean eq = this.eq(id, this.walkReference(new Reference("ecm:uuid")));
        return op == Operator.EQ ? eq : this.not(eq);
    }

    protected Boolean walkAncestorId(Operator op, Operand rvalue) {
        boolean eq;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:ancestorId requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:ancestorId requires literal id as right argument");
        }
        String ancestorId = ((StringLiteral)rvalue).value;
        Object[] ancestorIds = (Object[])this.walkReference(new Reference(NXQL_ECM_ANCESTOR_IDS));
        boolean bl = eq = op == Operator.EQ;
        if (ancestorIds == null) {
            return eq ? Boolean.FALSE : Boolean.TRUE;
        }
        for (Object id : ancestorIds) {
            if (!ancestorId.equals(id)) continue;
            return eq ? Boolean.TRUE : Boolean.FALSE;
        }
        return eq ? Boolean.FALSE : Boolean.TRUE;
    }

    public Boolean walkNot(Operand value) {
        return this.not(this.bool(this.walkOperand(value)));
    }

    public Boolean walkIsNull(Operand value) {
        return this.walkOperand(value) == null;
    }

    public Boolean walkIsNotNull(Operand value) {
        return this.walkOperand(value) != null;
    }

    public Boolean walkMultiExpression(MultiExpression expr) {
        Boolean res = Boolean.TRUE;
        for (Operand value : expr.values) {
            Boolean bool = this.bool(this.walkOperand(value));
            if (bool == null) {
                return null;
            }
            res = this.and(res, bool);
        }
        return res;
    }

    public Boolean walkAnd(Operand lvalue, Operand rvalue) {
        Boolean left = this.bool(this.walkOperand(lvalue));
        Boolean right = this.bool(this.walkOperand(rvalue));
        return this.and(left, right);
    }

    public Boolean walkOr(Operand lvalue, Operand rvalue) {
        Boolean left = this.bool(this.walkOperand(lvalue));
        Boolean right = this.bool(this.walkOperand(rvalue));
        return this.or(left, right);
    }

    public Boolean walkEq(Operand lvalue, Operand rvalue) {
        Object right = this.walkOperand(rvalue);
        if (this.isMixinTypes(lvalue)) {
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid EQ rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), true);
        }
        Object left = this.walkOperand(lvalue);
        return this.eqMaybeList(left, right);
    }

    public Boolean walkNotEq(Operand lvalue, Operand rvalue) {
        if (this.isMixinTypes(lvalue)) {
            Object right = this.walkOperand(rvalue);
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid NE rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), false);
        }
        return this.not(this.walkEq(lvalue, rvalue));
    }

    public Boolean walkLt(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp < 0);
    }

    public Boolean walkGt(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp > 0);
    }

    public Boolean walkLtEq(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp <= 0);
    }

    public Boolean walkGtEq(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp >= 0);
    }

    public Object walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList l = (LiteralList)rvalue;
        Predicate va = new Predicate(lvalue, Operator.GTEQ, (Operand)l.get(0));
        Predicate vb = new Predicate(lvalue, Operator.LTEQ, (Operand)l.get(1));
        Predicate pred = new Predicate((Operand)va, Operator.AND, (Operand)vb);
        if (!positive) {
            pred = new Predicate((Operand)pred, Operator.NOT, null);
        }
        return this.walkExpression((Expression)pred);
    }

    public Boolean walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof List)) {
            throw new QueryParseException("Invalid IN rhs: " + rvalue);
        }
        if (this.isMixinTypes(lvalue)) {
            return this.walkMixinTypes((List)right, positive);
        }
        Object left = this.walkOperand(lvalue);
        Boolean in = this.inMaybeList(left, (List)right);
        return positive ? in : this.not(in);
    }

    public Object walkOperand(Operand op) {
        if (op instanceof Literal) {
            return this.walkLiteral((Literal)op);
        }
        if (op instanceof LiteralList) {
            return this.walkLiteralList((LiteralList)op);
        }
        if (op instanceof Function) {
            return this.walkFunction((Function)op);
        }
        if (op instanceof Expression) {
            return this.walkExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.walkReference((Reference)op);
        }
        throw new QueryParseException("Unknown operand: " + op);
    }

    public Object walkLiteral(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return this.walkBooleanLiteral((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return this.walkDateLiteral((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return this.walkDoubleLiteral((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return this.walkIntegerLiteral((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return this.walkStringLiteral((StringLiteral)lit);
        }
        throw new QueryParseException("Unknown literal: " + lit);
    }

    public Boolean walkBooleanLiteral(BooleanLiteral lit) {
        return lit.value;
    }

    public Calendar walkDateLiteral(DateLiteral lit) {
        return lit.toCalendar();
    }

    public Double walkDoubleLiteral(DoubleLiteral lit) {
        return lit.value;
    }

    public Long walkIntegerLiteral(IntegerLiteral lit) {
        return lit.value;
    }

    public String walkStringLiteral(StringLiteral lit) {
        return lit.value;
    }

    public List<Object> walkLiteralList(LiteralList litList) {
        ArrayList<Object> list = new ArrayList<Object>(litList.size());
        for (Literal lit : litList) {
            list.add(this.walkLiteral(lit));
        }
        return list;
    }

    public Boolean walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof String)) {
            throw new QueryParseException("Invalid LIKE rhs: " + rvalue);
        }
        return this.likeMaybeList(left, (String)right, positive, caseInsensitive);
    }

    public Object walkFunction(Function func) {
        throw new UnsupportedOperationException("Function");
    }

    public Boolean walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new QueryParseException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    protected Boolean walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        if (ancestorId == null) {
            return Boolean.FALSE;
        }
        Object[] ancestorIds = (Object[])this.walkReference(new Reference(NXQL_ECM_ANCESTOR_IDS));
        if (ancestorIds == null) {
            return Boolean.FALSE;
        }
        for (Object id : ancestorIds) {
            if (!ancestorId.equals(id)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean walkStartsWithNonPath(Operand lvalue, String path) {
        Object left = this.walkReference((Reference)lvalue);
        Boolean bool = this.eqMaybeList(left, path);
        if (Boolean.TRUE.equals(bool)) {
            return Boolean.TRUE;
        }
        String pattern = path + "/%";
        return this.likeMaybeList(left, pattern, true, false);
    }

    public abstract Object walkReference(Reference var1);

    protected boolean isMixinTypes(Operand op) {
        if (!(op instanceof Reference)) {
            return false;
        }
        return ((Reference)op).name.equals("ecm:mixinType");
    }

    protected Boolean bool(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            throw new QueryParseException("Not a boolean: " + value);
        }
        return (Boolean)value;
    }

    protected Boolean not(Boolean value) {
        if (value == null) {
            return null;
        }
        return value == false;
    }

    protected Boolean and(Boolean left, Boolean right) {
        if (Boolean.TRUE.equals(left)) {
            return right;
        }
        return left;
    }

    protected Boolean or(Boolean left, Boolean right) {
        if (Boolean.TRUE.equals(left)) {
            return left;
        }
        return right;
    }

    protected Boolean eq(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        return left.equals(right);
    }

    protected Boolean in(Object left, List<Object> right) {
        if (left == null) {
            return null;
        }
        boolean hasNull = false;
        for (Object r : right) {
            if (r == null) {
                hasNull = true;
                continue;
            }
            if (!left.equals(r)) continue;
            return Boolean.TRUE;
        }
        return hasNull ? null : Boolean.FALSE;
    }

    protected Integer cmp(Operand lvalue, Operand rvalue) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.cmp(left, right);
    }

    protected Integer cmp(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Comparable)) {
            throw new QueryParseException("Not a comparable: " + left);
        }
        return ((Comparable)left).compareTo(right);
    }

    protected Boolean like(Object left, String right, boolean caseInsensitive) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof String)) {
            throw new QueryParseException("Invalid LIKE lhs: " + left);
        }
        String value = (String)left;
        if (caseInsensitive) {
            value = value.toLowerCase();
            right = right.toLowerCase();
        }
        String regex = ExpressionEvaluator.likeToRegex(right);
        boolean match = Pattern.matches(regex.toString(), value);
        return match;
    }

    public static String likeToRegex(String like) {
        StringBuilder regex = new StringBuilder();
        char[] chars = like.toCharArray();
        boolean escape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escapeNext = false;
            switch (c) {
                case '%': {
                    if (escape) {
                        regex.append(c);
                        break;
                    }
                    regex.append(".*");
                    break;
                }
                case '_': {
                    if (escape) {
                        regex.append(c);
                        break;
                    }
                    regex.append(".");
                    break;
                }
                case '\\': {
                    if (escape) {
                        regex.append("\\\\");
                        break;
                    }
                    escapeNext = true;
                    break;
                }
                default: {
                    if (!CharUtils.isAsciiAlphanumeric((char)c)) {
                        regex.append("\\");
                    }
                    regex.append(c);
                }
            }
            escape = escapeNext;
        }
        if (escape) {
            // empty if block
        }
        return regex.toString();
    }

    protected Boolean eqMaybeList(Object left, Object right) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean eq = this.eq(l, right);
                if (!Boolean.TRUE.equals(eq)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.eq(left, right);
    }

    protected Boolean inMaybeList(Object left, List<Object> right) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean in = this.in(l, right);
                if (!Boolean.TRUE.equals(in)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.in(left, right);
    }

    protected Boolean likeMaybeList(Object left, String right, boolean positive, boolean caseInsensitive) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean like = this.like(l, right, caseInsensitive);
                if (!Boolean.TRUE.equals(like)) continue;
                return positive;
            }
            return !positive;
        }
        Boolean like = this.like(left, right, caseInsensitive);
        return positive ? like : this.not(like);
    }

    public abstract Boolean walkMixinTypes(List<String> var1, boolean var2);

    public static interface PathResolver {
        public String getIdForPath(String var1);
    }
}

