/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class PropertiesExpandingStreamReader
extends StreamReaderDelegate {
    public static final String DELIMITER = "@";
    private final Map<String, String> props;

    public PropertiesExpandingStreamReader(XMLStreamReader reader, Map<String, String> props) {
        super(reader);
        this.props = props;
    }

    protected String expandProperty(String value) {
        String envValue;
        String propName;
        int endIndx;
        if (PropertiesExpandingStreamReader.isEmpty(value)) {
            return value;
        }
        int startIndx = value.indexOf(DELIMITER);
        if (startIndx > -1 && (endIndx = value.lastIndexOf(DELIMITER)) > -1 && startIndx + 1 < endIndx && !PropertiesExpandingStreamReader.isEmpty(propName = value.substring(startIndx + 1, endIndx)) && !PropertiesExpandingStreamReader.isEmpty(envValue = this.props.get(propName))) {
            StringBuilder sb = new StringBuilder();
            sb.append(value.substring(0, startIndx));
            sb.append(envValue);
            sb.append(value.substring(endIndx + 1));
            value = sb.toString();
        }
        return value;
    }

    private static boolean isEmpty(String str) {
        if (str != null) {
            int len = str.length();
            for (int x = 0; x < len; ++x) {
                if (str.charAt(x) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.expandProperty(super.getElementText());
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.expandProperty(super.getAttributeValue(namespaceURI, localName));
    }

    @Override
    public String getAttributeValue(int index) {
        return this.expandProperty(super.getAttributeValue(index));
    }

    @Override
    public String getText() {
        return this.expandProperty(super.getText());
    }
}

