/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleImageInfo {
    protected int width;
    protected int height;
    protected long length;
    protected String mimeType;
    protected InputStream in;

    public SimpleImageInfo(InputStream stream) throws IOException {
        this.in = stream instanceof BufferedInputStream ? stream : new BufferedInputStream(stream);
        this.processStream();
        this.finishStream();
        stream.close();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    protected void processStream() throws IOException {
        block8: {
            int c3;
            int c2;
            int c1;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            c1 = this.read();
                            c2 = this.read();
                            c3 = this.read();
                            this.mimeType = "application/octet-stream";
                            this.width = -1;
                            this.height = -1;
                            if (c1 != 71 || c2 != 73 || c3 != 70) break block9;
                            this.skip(3L);
                            this.width = this.readInt(2, false);
                            this.height = this.readInt(2, false);
                            this.mimeType = "image/gif";
                            break block8;
                        }
                        if (c1 != 255 || c2 != 216) break block10;
                        while (c3 == 255) {
                            int marker = this.read();
                            int len = this.readInt(2, true);
                            if (marker == 192 || marker == 193 || marker == 194) {
                                this.skip(1L);
                                this.height = this.readInt(2, true);
                                this.width = this.readInt(2, true);
                                this.mimeType = "image/jpeg";
                                break block8;
                            }
                            this.skip(len - 2);
                            c3 = this.read();
                        }
                        break block8;
                    }
                    if (c1 != 137 || c2 != 80 || c3 != 78) break block11;
                    this.skip(15L);
                    this.width = this.readInt(2, true);
                    this.skip(2L);
                    this.height = this.readInt(2, true);
                    this.mimeType = "image/png";
                    break block8;
                }
                if (c1 != 66 || c2 != 77) break block12;
                this.skip(15L);
                this.width = this.readInt(2, false);
                this.skip(2L);
                this.height = this.readInt(2, false);
                this.mimeType = "image/bmp";
                break block8;
            }
            int c4 = this.read();
            if ((c1 != 77 || c2 != 77 || c3 != 0 || c4 != 42) && (c1 != 73 || c2 != 73 || c3 != 42 || c4 != 0)) break block8;
            boolean bigEndian = c1 == 77;
            int ifd = 0;
            ifd = this.readInt(4, bigEndian);
            this.skip(ifd - 8);
            int entries = this.readInt(2, bigEndian);
            for (int i = 1; i <= entries; ++i) {
                int valOffset;
                int tag = this.readInt(2, bigEndian);
                int fieldType = this.readInt(2, bigEndian);
                long count = this.readInt(4, bigEndian);
                if (fieldType == 3 || fieldType == 8) {
                    valOffset = this.readInt(2, bigEndian);
                    this.skip(2L);
                } else {
                    valOffset = this.readInt(4, bigEndian);
                }
                if (tag == 256) {
                    this.width = valOffset;
                } else if (tag == 257) {
                    this.height = valOffset;
                }
                if (this.width == -1 || this.height == -1) continue;
                this.mimeType = "image/tiff";
                break;
            }
        }
    }

    protected int read() throws IOException {
        int c = this.in.read();
        if (c != -1) {
            ++this.length;
        }
        return c;
    }

    protected void skip(long n) throws IOException {
        long done;
        long num;
        for (done = 0L; done < n && (num = this.in.skip(n - done)) != 0L; done += num) {
        }
        this.length += done;
    }

    protected void finishStream() throws IOException {
        int n;
        byte[] buf = new byte[4096];
        while ((n = this.in.read(buf)) != -1) {
            this.length += (long)n;
        }
    }

    protected int readInt(int noOfBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (noOfBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < noOfBytes; ++i) {
            ret |= this.read() << sv;
            sv += cnt;
        }
        return ret;
    }
}

