/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.detectors;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;

public class MsoXML2007MimetypeSniffer
implements MagicDetector {
    private static final Log log = LogFactory.getLog(MsoXML2007MimetypeSniffer.class);

    public String getDisplayName() {
        return "Microsoft 2007 files MimeType Detector";
    }

    public String[] getHandledExtensions() {
        return new String[]{"docm", "docx", "dotm", "dotx", "ppsm", "ppsx", "pptm", "pptx", "xlsb", "xlsm", "xlsx", "xps"};
    }

    public String[] getHandledTypes() {
        return new String[]{"application/vnd.ms-word.document.macroEnabled.12", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.ms-word.template.macroEnabled.12", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-powerpoint.slideshow.macroEnabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.presentation.macroEnabled.12", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-excel.sheet.binary.macroEnabled.12", "application/vnd.ms-excel.sheet.macroEnabled.12", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.ms-xpsdocument"};
    }

    public String getName() {
        return "mso2007detector";
    }

    public String getVersion() {
        return "0.1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        String[] mimetypes = new String[]{};
        File file = null;
        try {
            file = File.createTempFile("magicdetector", ".xml");
            FileUtils.writeFile((File)file, (byte[])data);
            mimetypes = this.guessMsoXML2007(file);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return mimetypes;
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        return this.guessMsoXML2007(file);
    }

    public String[] guessMsoXML2007(File file) {
        String[] mimetype = new String[]{};
        try {
            ZipFile zipFile = new ZipFile(file);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return mimetype;
    }
}

