/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="relatedRouteAction")
@Scope(value=ScopeType.EVENT)
public class RelatedRouteActionBean {
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;

    @Factory(value="relatedRoutes")
    public List<DocumentModel> findRelatedRoute() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc != null) {
            return this.findRelatedRoute(currentDoc.getId());
        }
        return new ArrayList<DocumentModel>();
    }

    public List<DocumentModel> findRelatedRoute(String documentId) {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        if (documentId == null || "".equals(documentId)) {
            return docs;
        }
        List relatedRoutes = this.getDocumentRoutingService().getDocumentRoutesForAttachedDocument(this.documentManager, documentId);
        for (DocumentRoute documentRoute : relatedRoutes) {
            docs.add(documentRoute.getDocument());
        }
        return docs;
    }

    public boolean hasRelatedRoute(String documentId) {
        return !this.findRelatedRoute(documentId).isEmpty();
    }

    public boolean hasRelatedRoute() {
        return !this.findRelatedRoute().isEmpty();
    }

    public DocumentRoutingService getDocumentRoutingService() {
        return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
    }
}

