/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.InstanceRef;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.platform.task.TaskComment;

public interface Task
extends Serializable {
    public static final String TASK_PROVIDER_KEY = "taskProviderId";

    public DocumentModel getDocument();

    public String getId();

    @Deprecated
    public String getTargetDocumentId();

    public List<String> getActors();

    public String getInitiator();

    public String getName();

    public String getType();

    public String getProcessId();

    public String getProcessName();

    public String getDescription();

    public String getDirective();

    public List<TaskComment> getComments();

    public String getVariable(String var1);

    public Date getDueDate();

    public Date getCreated();

    public Boolean isCancelled();

    public Boolean isOpened();

    public Boolean hasEnded();

    public Boolean isAccepted();

    public Map<String, String> getVariables();

    public void setActors(List<String> var1);

    public void setInitiator(String var1);

    @Deprecated
    public void setTargetDocumentId(String var1);

    public void setName(String var1);

    public void setType(String var1);

    public void setProcessId(String var1);

    public void setProcessName(String var1);

    public void setDescription(String var1);

    public void setDirective(String var1);

    public void setVariable(String var1, String var2);

    public void setDueDate(Date var1);

    public void setCreated(Date var1);

    public void setAccepted(Boolean var1);

    public void setVariables(Map<String, String> var1);

    public void addComment(String var1, String var2);

    public void cancel(CoreSession var1);

    public void end(CoreSession var1);

    public List<String> getDelegatedActors();

    public void setDelegatedActors(List<String> var1);

    public List<String> getTargetDocumentsIds();

    public void setTargetDocumentsIds(List<String> var1);

    public static Optional<Task> optionalTask(EventContext context) {
        InstanceRef ref = (InstanceRef)context.getProperty("taskInstance");
        if (ref == null) {
            return Optional.empty();
        }
        Task task = (Task)((DocumentModel)ref.reference()).getAdapter(Task.class);
        return Optional.of(task);
    }

    public static enum TaskVariableName {
        needi18n,
        taskType;

    }
}

