/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.nuxeo.runtime.datasource.geronimo.PooledDataSourceFactory;

public class PooledDataSourceRegistry
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    protected final Map<String, PooledDataSource> pools = new HashMap<String, PooledDataSource>();
    protected final PooledDataSourceFactory poolFactory = new PooledDataSourceFactory();

    public <T> T getPool(String name, Class<T> type) {
        return type.cast(this.pools.get(name));
    }

    public DataSource getOrCreatePool(Object obj, Name objectName, Context nameCtx, Hashtable<?, ?> env) {
        Reference ref = (Reference)obj;
        String dsName = (String)ref.get("name").getContent();
        DataSource ds = this.pools.get(dsName);
        if (ds != null) {
            return ds;
        }
        return this.createPool(dsName, ref, objectName, nameCtx, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createPool(String dsName, Reference ref, Name objectName, Context nameCtx, Hashtable<?, ?> env) {
        PooledDataSource ds;
        try {
            this.readLock().lock();
            ds = this.pools.get(dsName);
            if (ds != null) {
                PooledDataSource pooledDataSource = ds;
                return pooledDataSource;
            }
            ds = (PooledDataSource)this.poolFactory.getObjectInstance(ref, objectName, nameCtx, env);
            this.pools.put(dsName, ds);
        }
        finally {
            this.readLock().unlock();
        }
        return ds;
    }

    protected void clearPool(String name) {
        PooledDataSource ds = this.pools.remove(name);
        if (ds != null) {
            ds.dispose();
        }
    }

    public void createAlias(String name, PooledDataSource pool) {
        this.pools.put(name, pool);
    }

    public static interface PooledDataSource
    extends DataSource {
        public void dispose();

        public Connection getConnection(boolean var1) throws SQLException;
    }

    public static interface Factory
    extends ObjectFactory {
    }
}

