/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DependencyTree<K, T>
implements Iterable<Entry<K, T>> {
    private final Map<K, Entry<K, T>> registry = new Hashtable<K, Entry<K, T>>();
    private final List<Entry<K, T>> resolved = new Vector<Entry<K, T>>();
    public static final int PHANTOM = 0;
    public static final int REGISTERED = 1;
    public static final int RESOLVED = 3;

    @Override
    public Iterator<Entry<K, T>> iterator() {
        return this.registry.values().iterator();
    }

    public Entry<K, T> add(K key, T object, K ... requires) {
        return this.add(key, object, (Collection<K>)Arrays.asList(requires));
    }

    public Entry<K, T> add(K key, T object, Collection<K> requires) {
        Entry<K, T> entry = this.registry.get(key);
        if (entry == null) {
            entry = new Entry<K, T>(key, object);
            this.registry.put(key, entry);
        } else if (((Entry)entry).object == null) {
            ((Entry)entry).object = object;
        } else {
            return entry;
        }
        this.updateDependencies(entry, requires);
        this.registered(entry);
        if (entry.canEnterResolvedState()) {
            this.resolve(entry);
        }
        return entry;
    }

    public void add(K key, T object) {
        this.add(key, object, (Collection)null);
    }

    public void remove(K key) {
        Entry<K, T> entry = this.registry.get(key);
        if (entry != null) {
            this.unregister(entry);
            ((Entry)entry).object = null;
            ((Entry)entry).waitsFor = null;
        }
    }

    public void unregister(Entry<K, T> entry) {
        if (entry.isResolved()) {
            this.unresolve(entry);
        }
        this.unregistered(entry);
    }

    public Entry<K, T> getEntry(K key) {
        return this.registry.get(key);
    }

    public T get(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return (T)(entry != null ? ((Entry)entry).object : null);
    }

    public T getResolved(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return (T)(entry != null && entry.isResolved() ? ((Entry)entry).object : null);
    }

    private void resolveEntry(Entry<K, T> entry) {
        this.resolved.add(entry);
        ((Entry)entry).isResolved = true;
        this.resolved(entry);
    }

    private void unresolveEntry(Entry<K, T> entry) {
        this.resolved.remove(entry);
        ((Entry)entry).isResolved = false;
        this.unresolved(entry);
    }

    public void resolve(Entry<K, T> entry) {
        this.resolveEntry(entry);
        Set<Entry<K, T>> deps = entry.getDependsOnMe();
        if (deps != null) {
            for (Entry<K, T> dep : deps) {
                dep.removeWaitingFor(entry);
                if (!dep.canEnterResolvedState()) continue;
                this.resolve(dep);
            }
        }
    }

    public void unresolve(Entry<K, T> entry) {
        Set<Entry<K, T>> deps = entry.getDependsOnMe();
        if (deps != null) {
            for (Entry<K, T> dep : deps) {
                dep.addWaitingFor(entry);
                if (!dep.isResolved()) continue;
                this.unresolve(dep);
            }
        }
        this.unresolveEntry(entry);
    }

    public boolean isPhantom(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return entry != null && entry.isPhantom();
    }

    public boolean isRegistered(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return entry != null && entry.isRegistered();
    }

    public boolean isResolved(K key) {
        Entry<K, T> entry = this.registry.get(key);
        return entry != null && entry.isResolved();
    }

    public Collection<Entry<K, T>> getEntries() {
        return this.registry.values();
    }

    public List<T> getRegisteredObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        Collection<Entry<K, T>> entries = this.getEntries();
        for (Entry<K, T> entry : entries) {
            list.add(((Entry)entry).object);
        }
        return list;
    }

    public List<Entry<K, T>> getPendingEntries() {
        ArrayList<Entry<K, T>> result = new ArrayList<Entry<K, T>>();
        for (Map.Entry<K, Entry<K, T>> entry : this.registry.entrySet()) {
            Entry<K, T> val = entry.getValue();
            if (val.isResolved()) continue;
            result.add(val);
        }
        return result;
    }

    public List<T> getPendingObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Entry<K, T>> entries = this.getPendingEntries();
        for (Entry<K, T> entry : entries) {
            list.add(((Entry)entry).object);
        }
        return list;
    }

    public List<Entry<K, T>> getMissingRequirements() {
        ArrayList<Entry<K, T>> result = new ArrayList<Entry<K, T>>();
        for (Map.Entry<K, Entry<K, T>> entry : this.registry.entrySet()) {
            Entry<K, T> val = entry.getValue();
            if (val.isRegistered()) continue;
            result.add(val);
        }
        return result;
    }

    public List<Entry<K, T>> getResolvedEntries() {
        return this.resolved;
    }

    public List<T> getResolvedObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Entry<K, T>> entries = this.resolved;
        for (Entry<K, T> entry : entries) {
            list.add(((Entry)entry).object);
        }
        return list;
    }

    public void clear() {
        for (Entry<K, T> entry : this.resolved) {
            if ((entry = this.registry.remove(((Entry)entry).key)) == null) continue;
            ((Entry)entry).isResolved = false;
            this.unresolved(entry);
            this.unregistered(entry);
        }
        this.resolved.clear();
        Iterator<Entry<K, T>> it = this.registry.values().iterator();
        while (it.hasNext()) {
            Entry<K, T> entry;
            entry = it.next();
            it.remove();
            if (!entry.isRegistered()) continue;
            this.unregistered(entry);
        }
    }

    protected void updateDependencies(Entry<K, T> entry, Collection<K> requires) {
        if (requires != null) {
            for (K req : requires) {
                Entry<K, Object> reqEntry = this.registry.get(req);
                if (reqEntry != null) {
                    if (reqEntry.isResolved()) {
                        reqEntry.addDependsOnMe(entry);
                        continue;
                    }
                } else {
                    reqEntry = new Entry<K, Object>(req, null);
                    this.registry.put(req, reqEntry);
                }
                reqEntry.addDependsOnMe(entry);
                entry.addWaitingFor(reqEntry);
            }
        }
    }

    protected void registered(Entry<K, T> entry) {
    }

    protected void unregistered(Entry<K, T> entry) {
    }

    protected void resolved(Entry<K, T> entry) {
    }

    protected void unresolved(Entry<K, T> entry) {
    }

    public static class Entry<K, T> {
        private final K key;
        private T object;
        private Set<Entry<K, T>> waitsFor;
        private Set<Entry<K, T>> dependsOnMe;
        private boolean isResolved = false;

        public Entry(K key, T object) {
            this.key = key;
            this.object = object;
        }

        public boolean isPhantom() {
            return this.object == null;
        }

        public boolean isRegistered() {
            return this.object != null;
        }

        public boolean isResolved() {
            return this.isResolved;
        }

        public final boolean canEnterResolvedState() {
            return !this.isResolved && this.object != null && this.waitsFor == null;
        }

        public final void addWaitingFor(Entry<K, T> entry) {
            if (this.waitsFor == null) {
                this.waitsFor = new HashSet<Entry<K, T>>();
            }
            this.waitsFor.add(entry);
        }

        public final void removeWaitingFor(Entry<K, T> key) {
            if (this.waitsFor != null) {
                this.waitsFor.remove(key);
                if (this.waitsFor.isEmpty()) {
                    this.waitsFor = null;
                }
            }
        }

        public final void addDependsOnMe(Entry<K, T> entry) {
            if (this.dependsOnMe == null) {
                this.dependsOnMe = new HashSet<Entry<K, T>>();
            }
            this.dependsOnMe.add(entry);
        }

        public Set<Entry<K, T>> getDependsOnMe() {
            return this.dependsOnMe;
        }

        public Set<Entry<K, T>> getWaitsFor() {
            return this.waitsFor;
        }

        public final T get() {
            return this.object;
        }

        public K getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            return this.key.equals(((Entry)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

