/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.resource;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ReloadableComponent;
import org.nuxeo.runtime.services.resource.ResourceDescriptor;

public class ResourceService
extends ReloadableComponent {
    public static final String XP_RESOURCES = "resources";
    protected Map<String, URL> registry;

    public URL getResource(String name) {
        return this.registry.get(name);
    }

    public void addResource(ResourceDescriptor resource) {
        this.addResource(resource.getName(), resource.getResource().toURL());
    }

    public void addResource(String name, URL url) {
        this.registry.put(name, url);
    }

    public URL removeResource(String name) {
        return this.registry.remove(name);
    }

    @Override
    public void activate(ComponentContext context) {
        this.registry = new ConcurrentHashMap<String, URL>();
    }

    @Override
    public void deactivate(ComponentContext context) {
        this.registry = null;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_RESOURCES.equals(extensionPoint)) {
            this.addResource((ResourceDescriptor)contribution);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_RESOURCES.equals(extensionPoint)) {
            ResourceDescriptor rd = (ResourceDescriptor)contribution;
            ResourceDescriptor last = this.findLastContributedResource(rd.getName());
            if (last != null) {
                this.addResource(last);
            } else {
                this.removeResource(rd.getName());
            }
        }
    }

    protected ResourceDescriptor findLastContributedResource(String name) {
        for (int i = this.extensions.size() - 1; i >= 0; --i) {
            Extension xt = (Extension)this.extensions.get(i);
            Object[] contribs = xt.getContributions();
            for (int k = contribs.length - 1; k >= 0; --k) {
                ResourceDescriptor r = (ResourceDescriptor)contribs[k];
                if (!name.equals(r.getName())) continue;
                return r;
            }
        }
        return null;
    }
}

