/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;

public class DBSExpressionEvaluator
extends ExpressionEvaluator {
    private static final Log log = LogFactory.getLog(DBSExpressionEvaluator.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    protected final SelectClause selectClause;
    protected final Expression expression;
    protected final SchemaManager schemaManager;
    protected List<String> documentTypes;
    protected State state;

    public DBSExpressionEvaluator(DBSSession session, SelectClause selectClause, Expression expression, String[] principals) {
        super((ExpressionEvaluator.PathResolver)new DBSPathResolver(session), principals);
        this.selectClause = selectClause;
        this.expression = expression;
        this.schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    }

    protected List<String> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList<String>();
            for (DocumentType docType : this.schemaManager.getDocumentTypes()) {
                this.documentTypes.add(docType.getName());
            }
        }
        return this.documentTypes;
    }

    protected Set<String> getMixinDocumentTypes(String mixin) {
        return this.schemaManager.getDocumentTypeNamesForFacet(mixin);
    }

    protected boolean isNeverPerInstanceMixin(String mixin) {
        return this.schemaManager.getNoPerDocumentQueryFacets().contains(mixin);
    }

    public boolean matches(State state) {
        this.state = state;
        if (this.principals != null) {
            String[] racl = (String[])this.walkReference(new Reference("ecm:__read_acl"));
            if (racl == null) {
                log.error((Object)("NULL racl for " + state.get((Object)"ecm:id")));
            } else {
                boolean allowed = false;
                for (String user : racl) {
                    if (!this.principals.contains(user)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    return false;
                }
            }
        }
        return Boolean.TRUE.equals(this.walkExpression(this.expression));
    }

    public boolean matches(DBSDocumentState docState) {
        return this.matches(docState.getState());
    }

    public Object walkReference(Reference ref) {
        return this.evaluateReference(ref, this.state);
    }

    protected Object evaluateReference(Reference ref, State state) {
        boolean isTrueOrNullBoolean;
        boolean isBoolean;
        boolean isArray;
        String name = ref.name;
        String[] split = name.split("/");
        String prop = split[0];
        if (name.startsWith("ecm:")) {
            prop = DBSSession.convToInternal(name);
            isArray = DBSSession.isArray(prop);
            isBoolean = DBSSession.isBoolean(prop);
            isTrueOrNullBoolean = true;
        } else {
            Field field = this.schemaManager.getField(prop);
            if (field == null) {
                if (prop.indexOf(58) > -1) {
                    throw new QueryParseException("No such property: " + name);
                }
                for (Schema schema : this.schemaManager.getSchemas()) {
                    if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(prop)) != null) break;
                }
                if (field == null) {
                    throw new QueryParseException("No such property: " + name);
                }
            }
            prop = field.getName().getPrefixedName();
            Type type = field.getType();
            isArray = type instanceof ListType && ((ListType)type).isArray();
            isBoolean = type instanceof BooleanType;
            isTrueOrNullBoolean = false;
            if (isArray && split[split.length - 1].startsWith("*")) {
                split = Arrays.copyOfRange(split, 0, split.length - 1);
            }
        }
        Object value = state.get((Object)prop);
        for (int i = 1; i < split.length; ++i) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof State)) {
                throw new QueryParseException("No such property (no State): " + name);
            }
            value = ((State)value).get((Object)split[i]);
        }
        if (value == null && isArray) {
            value = new Object[]{};
        }
        if (isBoolean) {
            value = isTrueOrNullBoolean ? (Boolean.TRUE.equals(value) ? ONE : ZERO) : (value == null ? null : ((Boolean)value != false ? ONE : ZERO));
        }
        return value;
    }

    public Boolean walkMixinTypes(List<String> mixins, boolean include) {
        List<Object> mixinTypes;
        HashSet<Object> matchPrimaryTypes;
        if (include) {
            matchPrimaryTypes = new HashSet();
            for (String string : mixins) {
                matchPrimaryTypes.addAll(this.getMixinDocumentTypes(string));
            }
        } else {
            matchPrimaryTypes = new HashSet<String>(this.getDocumentTypes());
            for (String string : mixins) {
                matchPrimaryTypes.removeAll(this.getMixinDocumentTypes(string));
            }
        }
        HashSet<String> matchMixinTypes = new HashSet<String>();
        for (String mixin : mixins) {
            if (this.isNeverPerInstanceMixin(mixin)) continue;
            matchMixinTypes.add(mixin);
        }
        String string = (String)((Object)this.state.get((Object)"ecm:primaryType"));
        Object[] mixinTypesArray = (Object[])this.state.get((Object)"ecm:mixinTypes");
        List<Object> list = mixinTypes = mixinTypesArray == null ? Collections.emptyList() : Arrays.asList(mixinTypesArray);
        if (include) {
            if (matchPrimaryTypes.contains(string)) {
                return Boolean.TRUE;
            }
            matchMixinTypes.retainAll(mixinTypes);
            return !matchMixinTypes.isEmpty();
        }
        if (!matchPrimaryTypes.contains(string)) {
            return Boolean.FALSE;
        }
        matchMixinTypes.retainAll(mixinTypes);
        return matchMixinTypes.isEmpty();
    }

    public static class OrderByComparator
    implements Comparator<State> {
        protected final OrderByClause orderByClause;
        protected DBSExpressionEvaluator evaluator;

        public OrderByComparator(OrderByClause orderByClause, DBSExpressionEvaluator evaluator) {
            OrderByList obl = new OrderByList(null);
            obl.clear();
            for (OrderByExpr ob : orderByClause.elements) {
                if (ob.reference.name.equals("ecm:path")) {
                    ob = new OrderByExpr(new Reference("ecm:__path"), ob.isDescending);
                }
                obl.add((Object)ob);
            }
            this.orderByClause = new OrderByClause(obl);
            this.evaluator = evaluator;
        }

        @Override
        public int compare(State s1, State s2) {
            Iterator iterator = this.orderByClause.elements.iterator();
            if (iterator.hasNext()) {
                OrderByExpr ob = (OrderByExpr)iterator.next();
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                int sign = desc ? -1 : 1;
                Object v1 = this.evaluator.evaluateReference(ref, s1);
                Object v2 = this.evaluator.evaluateReference(ref, s2);
                if (v1 == null) {
                    return v2 == null ? 0 : -sign;
                }
                if (v2 == null) {
                    return sign;
                }
                if (!(v1 instanceof Comparable)) {
                    throw new QueryParseException("Not a comparable: " + v1);
                }
                int cmp = ((Comparable)v1).compareTo(v2);
                return desc ? -cmp : cmp;
            }
            return 0;
        }
    }

    protected static class DBSPathResolver
    implements ExpressionEvaluator.PathResolver {
        protected final DBSSession session;

        public DBSPathResolver(DBSSession session) {
            this.session = session;
        }

        public String getIdForPath(String path) {
            return this.session.getDocumentIdByPath(path);
        }
    }
}

