/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.DefaultFulltextParser;
import org.nuxeo.ecm.core.storage.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.FulltextUpdaterWork;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSFulltextExtractorWork;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class DBSTransactionState {
    private static final Log log = LogFactory.getLog(DBSTransactionState.class);
    private static final String KEY_UNDOLOG_CREATE = "__UNDOLOG_CREATE__\u0000\u0000";
    protected final DBSRepository repository;
    protected final DBSSession session;
    protected Map<String, DBSDocumentState> transientStates = new HashMap<String, DBSDocumentState>();
    protected Set<String> transientCreated = new LinkedHashSet<String>();
    protected Map<String, State> undoLog;
    protected final Set<String> browsePermissions;

    public DBSTransactionState(DBSRepository repository, DBSSession session) {
        this.repository = repository;
        this.session = session;
        SecurityService securityService = (SecurityService)Framework.getLocalService(SecurityService.class);
        this.browsePermissions = new HashSet<String>(Arrays.asList(securityService.getPermissionsToCheck("Browse")));
    }

    protected FulltextConfiguration getFulltextConfiguration() {
        FulltextConfiguration fulltextConfiguration = new FulltextConfiguration();
        fulltextConfiguration.indexNames.add("default");
        fulltextConfiguration.indexesAllBinary.add("default");
        return fulltextConfiguration;
    }

    protected DBSDocumentState newTransientState(State state) {
        if (state == null) {
            return null;
        }
        String id = (String)((Object)state.get((Object)"ecm:id"));
        if (this.transientStates.containsKey(id)) {
            throw new IllegalStateException("Already transient: " + id);
        }
        DBSDocumentState docState = new DBSDocumentState(state);
        this.transientStates.put(id, docState);
        return docState;
    }

    public DBSDocumentState getStateForUpdate(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState;
        }
        State state = this.repository.readState(id);
        return this.newTransientState(state);
    }

    public State getStateForRead(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState.getState();
        }
        return this.repository.readState(id);
    }

    public List<DBSDocumentState> getStatesForUpdate(List<String> ids) {
        LinkedList<String> idsToFetch = new LinkedList<String>();
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState != null) continue;
            idsToFetch.add(id);
        }
        if (!idsToFetch.isEmpty()) {
            List<State> states = this.repository.readStates(idsToFetch);
            for (State state : states) {
                this.newTransientState(state);
            }
        }
        ArrayList<DBSDocumentState> docStates = new ArrayList<DBSDocumentState>(ids.size());
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState != null) {
                docStates.add(docState);
                continue;
            }
            log.warn((Object)("Cannot fetch document with id: " + id), new Throwable("debug stack trace"));
        }
        return docStates;
    }

    public DBSDocumentState getChildState(String parentId, String name) {
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return docState;
        }
        State state = this.repository.readChildState(parentId, name, seen);
        return this.newTransientState(state);
    }

    public boolean hasChild(String parentId, String name) {
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return true;
        }
        return this.repository.hasChild(parentId, name, seen);
    }

    public List<DBSDocumentState> getChildrenStates(String parentId) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId())) continue;
            docStates.add(docState);
        }
        List<State> states = this.repository.queryKeyValue("ecm:parentId", parentId, seen);
        for (State state : states) {
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public List<String> getChildrenIds(String parentId) {
        ArrayList<String> children = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            String id = docState.getId();
            seen.add(id);
            if (!parentId.equals(docState.getParentId())) continue;
            children.add(id);
        }
        List<State> states = this.repository.queryKeyValue("ecm:parentId", parentId, seen);
        for (State state : states) {
            children.add((String)((Object)state.get((Object)"ecm:id")));
        }
        return new ArrayList<String>(children);
    }

    public boolean hasChildren(String parentId) {
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId())) continue;
            return true;
        }
        return this.repository.queryKeyValuePresence("ecm:parentId", parentId, seen);
    }

    public DBSDocumentState createChild(String id, String parentId, String name, Long pos, String typeName) {
        if (id == null) {
            id = this.repository.generateNewId();
        }
        this.transientCreated.add(id);
        DBSDocumentState docState = new DBSDocumentState();
        this.transientStates.put(id, docState);
        docState.put("ecm:id", (Serializable)((Object)id));
        docState.put("ecm:parentId", (Serializable)((Object)parentId));
        docState.put("ecm:ancestorIds", (Serializable)this.getAncestorIds(parentId));
        docState.put("ecm:name", (Serializable)((Object)name));
        docState.put("ecm:pos", pos);
        docState.put("ecm:primaryType", (Serializable)((Object)typeName));
        this.updateReadAcls(id);
        return docState;
    }

    protected Object[] getAncestorIds(String id) {
        if (id == null) {
            return null;
        }
        State state = this.getStateForRead(id);
        if (state == null) {
            throw new RuntimeException("No such id: " + id);
        }
        Object[] ancestors = (Object[])state.get((Object)"ecm:ancestorIds");
        if (ancestors == null) {
            return new Object[]{id};
        }
        Object[] newAncestors = new Object[ancestors.length + 1];
        System.arraycopy(ancestors, 0, newAncestors, 0, ancestors.length);
        newAncestors[ancestors.length] = id;
        return newAncestors;
    }

    public DBSDocumentState copy(String id) {
        DBSDocumentState copyState = new DBSDocumentState(this.getStateForRead(id));
        String copyId = this.repository.generateNewId();
        copyState.put("ecm:id", (Serializable)((Object)copyId));
        this.transientStates.put(copyId, copyState);
        this.transientCreated.add(copyId);
        return copyState;
    }

    public void updateAncestors(String id, int ndel, Object[] ancestorIds) {
        int nadd = ancestorIds.length;
        Set<String> ids = this.getSubTree(id, null, null);
        ids.add(id);
        for (String cid : ids) {
            Object[] newAncestors;
            DBSDocumentState docState = this.getStateForUpdate(cid);
            Object[] ancestors = (Object[])docState.get("ecm:ancestorIds");
            if (ancestors == null) {
                newAncestors = (Object[])ancestorIds.clone();
            } else {
                newAncestors = new Object[ancestors.length - ndel + nadd];
                System.arraycopy(ancestorIds, 0, newAncestors, 0, nadd);
                System.arraycopy(ancestors, ndel, newAncestors, nadd, ancestors.length - ndel);
            }
            docState.put("ecm:ancestorIds", (Serializable)newAncestors);
        }
    }

    public void updateReadAcls(String id) {
        Set<String> ids = this.getSubTree(id, null, null);
        ids.add(id);
        for (String cid : ids) {
            DBSDocumentState docState = this.getStateForUpdate(cid);
            docState.put("ecm:racl", (Serializable)this.getReadACL(docState));
        }
    }

    protected String[] getReadACL(DBSDocumentState docState) {
        HashSet<String> racls = new HashSet<String>();
        State state = docState.getState();
        block0: do {
            List aclList;
            if ((aclList = (List)((Object)state.get((Object)"ecm:acp"))) != null) {
                for (Serializable aclSer : aclList) {
                    State aclMap = (State)aclSer;
                    List aceList = (List)((Object)aclMap.get((Object)"acl"));
                    for (Serializable aceSer : aceList) {
                        State aceMap = (State)aceSer;
                        String username = (String)((Object)aceMap.get((Object)"user"));
                        String permission = (String)((Object)aceMap.get((Object)"perm"));
                        Boolean granted = (Boolean)aceMap.get((Object)"grant");
                        if (Boolean.TRUE.equals(granted) && this.browsePermissions.contains(permission)) {
                            racls.add(username);
                        }
                        if (!Boolean.FALSE.equals(granted)) continue;
                        if ("Everyone".equals(username)) break block0;
                        racls.add("_UNSUPPORTED_ACL_");
                        break block0;
                    }
                }
            }
            if (Boolean.TRUE.equals(state.get((Object)"ecm:isVersion"))) {
                String versionSeriesId = (String)((Object)state.get((Object)"ecm:versionSeriesId"));
                state = versionSeriesId == null ? null : this.getStateForRead(versionSeriesId);
                continue;
            }
            String parentId = (String)((Object)state.get((Object)"ecm:parentId"));
            State state2 = state = parentId == null ? null : this.getStateForRead(parentId);
        } while (state != null);
        ArrayList racl = new ArrayList(racls);
        Collections.sort(racl);
        return racl.toArray(new String[racl.size()]);
    }

    protected Set<String> getSubTree(String id, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        HashSet<String> ids = new HashSet<String>();
        this.repository.queryKeyValueArray("ecm:ancestorIds", id, ids, proxyTargets, targetProxies);
        return ids;
    }

    public List<DBSDocumentState> getKeyValuedStates(String key, Object value) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!value.equals(docState.get(key))) continue;
            docStates.add(docState);
        }
        List<State> states = this.repository.queryKeyValue(key, value, seen);
        for (State state : states) {
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public List<DBSDocumentState> getKeyValuedStates(String key1, Object value1, String key2, Object value2) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!value1.equals(docState.get(key1)) || !value2.equals(docState.get(key2))) continue;
            docStates.add(docState);
        }
        List<State> states = this.repository.queryKeyValue(key1, value1, key2, value2, seen);
        for (State state : states) {
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public void removeStates(Set<String> ids) {
        if (this.undoLog != null) {
            for (String id : ids) {
                if (this.undoLog.containsKey(id)) {
                    State oldUndo = this.undoLog.get(id);
                    if (oldUndo == null) {
                        this.undoLog.remove(id);
                        continue;
                    }
                    oldUndo.put(KEY_UNDOLOG_CREATE, (Serializable)Boolean.TRUE);
                    continue;
                }
                State oldState = StateHelper.deepCopy((State)this.getStateForRead(id));
                oldState.put(KEY_UNDOLOG_CREATE, (Serializable)Boolean.TRUE);
                this.undoLog.put(id, oldState);
            }
        }
        for (String id : ids) {
            this.transientStates.remove(id);
        }
        this.repository.deleteStates(ids);
    }

    public void save() {
        this.updateProxies();
        List<Object> works = !this.repository.isFulltextDisabled() ? this.getFulltextWorks() : Collections.emptyList();
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            docState.setNotDirty();
            if (this.undoLog != null) {
                this.undoLog.put(id, null);
            }
            this.repository.createState(docState.getState());
        }
        for (DBSDocumentState docState : this.transientStates.values()) {
            String id = docState.getId();
            if (this.transientCreated.contains(id)) continue;
            State.StateDiff diff = docState.getStateChange();
            if (diff != null) {
                if (this.undoLog != null && !this.undoLog.containsKey(id)) {
                    this.undoLog.put(id, StateHelper.deepCopy((State)docState.getOriginalState()));
                }
                this.repository.updateState(id, diff);
            }
            docState.setNotDirty();
        }
        this.transientCreated.clear();
        this.scheduleWork(works);
    }

    protected void applyUndoLog() {
        HashSet<String> deletes = new HashSet<String>();
        for (Map.Entry<String, State> es : this.undoLog.entrySet()) {
            State.StateDiff diff;
            boolean recreate;
            String id = es.getKey();
            State state = es.getValue();
            if (state == null) {
                deletes.add(id);
                continue;
            }
            boolean bl = recreate = state.remove((Object)KEY_UNDOLOG_CREATE) != null;
            if (recreate) {
                this.repository.createState(state);
                continue;
            }
            State currentState = this.repository.readState(id);
            if (currentState == null || (diff = StateHelper.diff((State)currentState, (State)state)).isEmpty()) continue;
            this.repository.updateState(id, diff);
        }
        if (!deletes.isEmpty()) {
            this.repository.deleteStates(deletes);
        }
    }

    protected void updateProxies() {
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
            if (proxyIds == null) continue;
            for (Object proxyId : proxyIds) {
                this.updateProxy(docState, (String)proxyId);
            }
        }
        for (String id : this.transientStates.keySet().toArray(new String[0])) {
            Object[] proxyIds;
            DBSDocumentState docState = this.transientStates.get(id);
            if (this.transientCreated.contains(id) || !docState.isDirty() || (proxyIds = (Object[])docState.get("ecm:proxyIds")) == null) continue;
            for (Object proxyId : proxyIds) {
                try {
                    this.updateProxy(docState, (String)proxyId);
                }
                catch (ConcurrentUpdateException e) {
                    e.addInfo("On doc " + docState.getId());
                    throw e;
                }
            }
        }
    }

    protected void updateProxy(DBSDocumentState target, String proxyId) {
        DBSDocumentState proxy = this.getStateForUpdate(proxyId);
        if (proxy == null) {
            this.rollback();
            throw new ConcurrentUpdateException("Proxy " + proxyId + " concurrently deleted");
        }
        for (String key : proxy.getState().keyArray()) {
            if (this.isProxySpecific(key)) continue;
            proxy.put(key, null);
        }
        for (Map.Entry en : target.getState().entrySet()) {
            String key = (String)en.getKey();
            if (this.isProxySpecific(key)) continue;
            proxy.put(key, StateHelper.deepCopy(en.getValue()));
        }
    }

    protected boolean isProxySpecific(String key) {
        switch (key) {
            case "ecm:id": 
            case "ecm:parentId": 
            case "ecm:ancestorIds": 
            case "ecm:name": 
            case "ecm:pos": 
            case "ecm:acp": 
            case "ecm:racl": 
            case "ecm:isProxy": 
            case "ecm:proxyTargetId": 
            case "ecm:proxyVersionSeriesId": 
            case "ecm:isVersion": 
            case "ecm:proxyIds": {
                return true;
            }
        }
        return false;
    }

    public void begin() {
        this.undoLog = new HashMap<String, State>();
    }

    public void commit() {
        this.save();
        this.commitSave();
    }

    protected void commitSave() {
        this.clearTransient();
        this.undoLog = null;
    }

    public void rollback() {
        this.clearTransient();
        this.applyUndoLog();
        this.undoLog = null;
    }

    protected void clearTransient() {
        this.transientStates.clear();
        this.transientCreated.clear();
    }

    protected List<Work> getFulltextWorks() {
        HashSet<String> docsWithDirtyStrings = new HashSet<String>();
        HashSet<String> docsWithDirtyBinaries = new HashSet<String>();
        this.findDirtyDocuments(docsWithDirtyStrings, docsWithDirtyBinaries);
        if (docsWithDirtyStrings.isEmpty() && docsWithDirtyBinaries.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Work> works = new LinkedList<Work>();
        this.getFulltextSimpleWorks(works, docsWithDirtyStrings);
        this.getFulltextBinariesWorks(works, docsWithDirtyBinaries);
        return works;
    }

    protected void findDirtyDocuments(Set<String> docsWithDirtyStrings, Set<String> docWithDirtyBinaries) {
        for (String id : this.transientCreated) {
            docsWithDirtyStrings.add(id);
            docWithDirtyBinaries.add(id);
        }
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!docState.isDirtyIgnoringFulltext()) continue;
            String id = docState.getId();
            docsWithDirtyStrings.add(id);
            docWithDirtyBinaries.add(id);
        }
    }

    protected void getFulltextSimpleWorks(List<Work> works, Set<String> docsWithDirtyStrings) {
        DefaultFulltextParser fulltextParser = new DefaultFulltextParser();
        for (String id : docsWithDirtyStrings) {
            if (id == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            DBSDocumentState docState = this.getStateForUpdate(id);
            if (docState == null) continue;
            String documentType = docState.getPrimaryType();
            FulltextConfiguration config = this.getFulltextConfiguration();
            if (!config.isFulltextIndexable(documentType)) continue;
            docState.put("ecm:fulltextJobId", (Serializable)((Object)docState.getId()));
            FulltextFinder fulltextFinder = new FulltextFinder((FulltextParser)fulltextParser, docState, this.session);
            LinkedList<FulltextUpdaterWork.IndexAndText> indexesAndText = new LinkedList<FulltextUpdaterWork.IndexAndText>();
            for (String indexName : config.indexNames) {
                String text = fulltextFinder.findFulltext(indexName);
                indexesAndText.add(new FulltextUpdaterWork.IndexAndText(indexName, text));
            }
            if (indexesAndText.isEmpty()) continue;
            FulltextUpdaterWork work = new FulltextUpdaterWork(this.repository.getName(), id, true, false, indexesAndText);
            works.add((Work)work);
        }
    }

    protected void getFulltextBinariesWorks(List<Work> works, Set<String> docWithDirtyBinaries) {
        if (docWithDirtyBinaries.isEmpty()) {
            return;
        }
        FulltextConfiguration config = this.getFulltextConfiguration();
        for (String id : docWithDirtyBinaries) {
            DBSDocumentState docState = this.getStateForUpdate(id);
            if (docState == null || !config.isFulltextIndexable(docState.getPrimaryType())) continue;
            docState.put("ecm:fulltextJobId", (Serializable)((Object)docState.getId()));
        }
        for (String id : docWithDirtyBinaries) {
            DBSFulltextExtractorWork work = new DBSFulltextExtractorWork(this.repository.getName(), id);
            works.add((Work)work);
        }
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            }
        }
    }

    protected static class FulltextFinder {
        protected final FulltextParser fulltextParser;
        protected final DBSDocumentState document;
        protected final DBSSession session;
        protected final String documentType;
        protected final Object[] mixinTypes;

        public FulltextFinder(FulltextParser fulltextParser, DBSDocumentState document, DBSSession session) {
            this.fulltextParser = fulltextParser;
            this.document = document;
            this.session = session;
            if (document == null) {
                this.documentType = null;
                this.mixinTypes = null;
            } else {
                this.documentType = document.getPrimaryType();
                this.mixinTypes = (Object[])document.get("ecm:mixinTypes");
            }
        }

        public String findFulltext(String indexName) {
            ArrayList<String> strings = new ArrayList<String>();
            this.findFulltext(indexName, this.document.getState(), strings);
            return StringUtils.join(strings, (char)' ');
        }

        protected void findFulltext(String indexName, State state, List<String> strings) {
            block6: for (Map.Entry en : state.entrySet()) {
                Serializable value;
                String key = (String)en.getKey();
                if (key.startsWith("ecm:")) {
                    switch (key) {
                        case "ecm:name": {
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
                if ((value = (Serializable)en.getValue()) instanceof State) {
                    State s = (State)value;
                    this.findFulltext(indexName, s, strings);
                    continue;
                }
                if (value instanceof List) {
                    List v = (List)((Object)value);
                    for (State s : v) {
                        this.findFulltext(indexName, s, strings);
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] ar;
                    for (Object v : ar = (Object[])value) {
                        if (!(v instanceof String)) break;
                        this.fulltextParser.parse((String)v, null, strings);
                    }
                    continue;
                }
                if (!(value instanceof String)) continue;
                this.fulltextParser.parse((String)((Object)value), null, strings);
            }
        }
    }
}

