/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.sun.jersey.api.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Provider
public class WebEngineExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    HttpHeaders headers;
    protected static final Log log = LogFactory.getLog(WebEngineExceptionMapper.class);

    public Response toResponse(Throwable cause) {
        TransactionHelper.setTransactionRollbackOnly();
        if (this.headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE) && cause instanceof DocumentValidationException) {
            DocumentValidationException dve = (DocumentValidationException)cause;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)dve.getReport()).build();
        }
        if (cause instanceof NotFoundException) {
            NotFoundException nfe = (NotFoundException)cause;
            log.debug((Object)("JAX-RS 404 Not Found: " + nfe.getNotFoundUri()));
        } else if (cause instanceof WebResourceNotFoundException) {
            WebResourceNotFoundException nfe = (WebResourceNotFoundException)((Object)cause);
            log.debug((Object)("JAX-RS 404 Not Found: " + nfe.getMessage()));
        } else {
            log.warn((Object)"Exception in JAX-RS processing", cause);
        }
        return WebException.newException(cause.getMessage(), (Throwable)((Object)WebException.wrap(cause))).toResponse();
    }
}

