/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.JenaException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;
import org.slf4j.LoggerFactory;

public abstract class JenaReaderRIOT
implements RDFReader {
    protected RDFErrorHandler errorHandler = null;

    protected JenaReaderRIOT() {
    }

    public final void read(Model model, Reader r, String base) {
        this.checkReader(r);
        this.readImpl(model, this.makeTokenizer(r), base);
    }

    public final void read(Model model, String url) {
        try {
            URLConnection conn = new URL(url).openConnection();
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(model, new InputStreamReader(conn.getInputStream(), "utf-8"), url);
            } else {
                if (!encoding.equalsIgnoreCase("UTF-8")) {
                    LoggerFactory.getLogger(this.getClass()).warn("URL content is not UTF-8");
                }
                this.read(model, new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (JenaException e2) {
            if (this.errorHandler == null) {
                throw e2;
            }
            this.errorHandler.error((Exception)((Object)e2));
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException((Throwable)ex);
            }
            this.errorHandler.error(ex);
        }
    }

    public final void read(Model model, InputStream in, String base) {
        this.readImpl(model, this.makeTokenizer(in), base);
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        return TokenizerFactory.makeTokenizerUTF8(in);
    }

    protected Tokenizer makeTokenizer(Reader r) {
        return TokenizerFactory.makeTokenizer(r);
    }

    public final RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public final Object setProperty(String propName, Object propValue) {
        return null;
    }

    protected void checkReader(Reader r) {
        FileReader f;
        if (r instanceof FileReader && (f = (FileReader)r).getEncoding().equalsIgnoreCase("utf-8")) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader is not UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Model model, Tokenizer tokenizer, String base) {
        try {
            model.notifyEvent((Object)GraphEvents.startRead);
            this.readWorker(model, tokenizer, base);
        }
        catch (JenaException e2) {
            if (this.errorHandler == null) {
                throw e2;
            }
            this.errorHandler.error((Exception)((Object)e2));
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException((Throwable)ex);
            }
            this.errorHandler.error(ex);
        }
        finally {
            model.notifyEvent((Object)GraphEvents.finishRead);
        }
    }

    protected abstract void readWorker(Model var1, Tokenizer var2, String var3) throws Exception;
}

