/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionServiceImpl;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRenditionBuilderWork
extends AbstractWork
implements Work,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String key;
    protected final DocumentRef docRef;
    protected final String repositoryName;
    protected final String renditionName;
    protected static Log log = LogFactory.getLog(AbstractRenditionBuilderWork.class);

    public AbstractRenditionBuilderWork(String key, DocumentModel doc, RenditionDefinition def) {
        this.key = key;
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.renditionName = def.getName();
    }

    public String getId() {
        return "rendition:" + this.key;
    }

    public String getTitle() {
        return "Lazy Rendition for " + this.renditionName + " on " + this.docRef.toString();
    }

    protected String getTransientStoreName() {
        return "LazyRenditionCache";
    }

    public void work() {
        this.initSession();
        DocumentModel doc = this.session.getDocument(this.docRef);
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = ((RenditionServiceImpl)rs).getRenditionDefinition(this.renditionName);
        List<Blob> blobs = this.doComputeRendition(this.session, doc, def);
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        if (!ts.exists(this.key)) {
            throw new NuxeoException("Rendition TransientStore entry can not be null");
        }
        ts.putBlobs(this.key, blobs);
        ts.setCompleted(this.key, true);
    }

    protected abstract List<Blob> doComputeRendition(CoreSession var1, DocumentModel var2, RenditionDefinition var3);
}

