/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentStringBlobHolder;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class RenditionCreator
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(RenditionCreator.class);
    public static final String FILE = "File";
    protected DocumentModel detachedRendition;
    protected String liveDocumentId;
    protected String versionDocumentId;
    protected Blob renditionBlob;
    protected String renditionName;

    public RenditionCreator(CoreSession session, DocumentModel liveDocument, DocumentModel versionDocument, Blob renditionBlob, String renditionName) {
        super(session);
        this.liveDocumentId = liveDocument.getId();
        this.versionDocumentId = versionDocument == null ? null : versionDocument.getId();
        this.renditionBlob = renditionBlob;
        this.renditionName = renditionName;
    }

    public DocumentModel getDetachedRendition() {
        return this.detachedRendition;
    }

    @Deprecated
    public DocumentModel getDetachedDendition() {
        return this.detachedRendition;
    }

    public void run() {
        DocumentModel liveDocument = this.session.getDocument((DocumentRef)new IdRef(this.liveDocumentId));
        DocumentModel sourceDocument = liveDocument.isVersionable() ? this.session.getDocument((DocumentRef)new IdRef(this.versionDocumentId)) : liveDocument;
        DocumentModel rendition = this.createRenditionDocument(sourceDocument);
        this.removeBlobs(rendition);
        this.updateMainBlob(rendition);
        this.updateIconAndSizeFields(rendition);
        if (rendition.getId() == null) {
            rendition = this.session.createDocument(rendition);
        }
        if (sourceDocument.isVersionable()) {
            this.setCorrectVersion(rendition, sourceDocument);
        } else {
            this.giveReadRightToUser(rendition);
        }
        rendition.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
        rendition = this.session.saveDocument(rendition);
        if (sourceDocument.isVersionable()) {
            DocumentRef renditionRef = rendition.checkIn(VersioningOption.NONE, null);
            rendition = this.session.getDocument(renditionRef);
        }
        this.session.save();
        rendition.detach(true);
        this.detachedRendition = rendition;
    }

    protected DocumentModel createRenditionDocument(DocumentModel sourceDocument) {
        DocumentModel rendition;
        DocumentModelList existingRenditions;
        boolean isVersionable;
        String doctype = sourceDocument.getType();
        String renditionMimeType = this.renditionBlob.getMimeType();
        BlobHolder blobHolder = (BlobHolder)sourceDocument.getAdapter(BlobHolder.class);
        if (blobHolder == null || blobHolder instanceof DocumentStringBlobHolder && !renditionMimeType.startsWith("text/") && !renditionMimeType.startsWith("application/xhtml")) {
            doctype = FILE;
        }
        String liveDocProp = (isVersionable = sourceDocument.isVersionable()) ? "rend:sourceVersionableId" : "rend:sourceId";
        try (CoreSession userSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)this.getOriginatingUsername());){
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM Document WHERE ecm:isProxy = 0 AND ");
            query.append("rend:renditionName");
            query.append(" = '");
            query.append(this.renditionName);
            query.append("' AND ");
            query.append(liveDocProp);
            query.append(" = '");
            query.append(this.liveDocumentId);
            query.append("'");
            existingRenditions = userSession.query(query.toString());
        }
        String modificationDatePropertyName = this.getSourceDocumentModificationDatePropertyName();
        Calendar sourceLastModified = (Calendar)sourceDocument.getPropertyValue(modificationDatePropertyName);
        if (existingRenditions.size() > 0) {
            Calendar renditionSourceLastModified;
            rendition = this.session.getDocument(((DocumentModel)existingRenditions.get(0)).getRef());
            if (!isVersionable && (renditionSourceLastModified = (Calendar)rendition.getPropertyValue("rend:sourceModificationDate")) != null && !renditionSourceLastModified.before(sourceLastModified)) {
                this.renditionBlob = (Blob)rendition.getPropertyValue("file:content");
                return rendition;
            }
            if (rendition.isVersion()) {
                String sid = rendition.getVersionSeriesId();
                rendition = this.session.getDocument((DocumentRef)new IdRef(sid));
            }
        } else {
            rendition = this.session.createDocumentModel(null, sourceDocument.getName(), doctype);
        }
        rendition.copyContent(sourceDocument);
        rendition.getContextData().putScopedValue("initialLifecycleState", (Serializable)((Object)sourceDocument.getCurrentLifeCycleState()));
        rendition.addFacet("Rendition");
        rendition.setPropertyValue("rend:sourceId", (Serializable)((Object)sourceDocument.getId()));
        if (isVersionable) {
            rendition.setPropertyValue("rend:sourceVersionableId", (Serializable)((Object)this.liveDocumentId));
        }
        if (sourceLastModified != null) {
            rendition.setPropertyValue("rend:sourceModificationDate", (Serializable)sourceLastModified);
        }
        rendition.setPropertyValue("rend:renditionName", (Serializable)((Object)this.renditionName));
        return rendition;
    }

    protected void removeBlobs(DocumentModel rendition) {
        if (rendition.hasSchema("files")) {
            rendition.setPropertyValue("files:files", new ArrayList());
        }
    }

    protected void updateMainBlob(DocumentModel rendition) {
        BlobHolder bh = (BlobHolder)rendition.getAdapter(BlobHolder.class);
        bh.setBlob(this.renditionBlob);
    }

    private void updateIconAndSizeFields(DocumentModel rendition) {
        MimetypeRegistry mimetypeService;
        if (!rendition.hasSchema("common")) {
            return;
        }
        try {
            mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        catch (Exception e) {
            log.error((Object)"Cannot fetch Mimetype service when updating icon and file size rendition", (Throwable)e);
            return;
        }
        MimetypeEntry mimetypeEntry = mimetypeService.getMimetypeEntryByMimeType(this.renditionBlob.getMimeType());
        if (mimetypeEntry != null && mimetypeEntry.getIconPath() != null) {
            rendition.setPropertyValue("common:icon", (Serializable)((Object)("/icons/" + mimetypeEntry.getIconPath())));
        }
        rendition.setPropertyValue("common:size", (Serializable)Long.valueOf(this.renditionBlob.getLength()));
    }

    protected void giveReadRightToUser(DocumentModel rendition) {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl();
        acp.addACL((ACL)acl);
        ACE ace = new ACE(this.getOriginatingUsername(), "Read", true);
        acl.add(ace);
        rendition.setACP((ACP)acp, true);
    }

    protected void setCorrectVersion(DocumentModel rendition, DocumentModel versionDocument) {
        Long minorVersion = (Long)versionDocument.getPropertyValue("uid:minor_version");
        rendition.setPropertyValue("uid:minor_version", (Serializable)minorVersion);
        rendition.setPropertyValue("uid:major_version", versionDocument.getPropertyValue("uid:major_version"));
    }

    protected String getSourceDocumentModificationDatePropertyName() {
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = ((RenditionServiceImpl)rs).getRenditionDefinition(this.renditionName);
        return def.getSourceDocumentModificationDatePropertyName();
    }
}

