/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class RenditionFinder
extends UnrestrictedSessionRunner {
    protected final DocumentModel source;
    protected DocumentModel storedRendition;
    protected final String renditionName;

    protected RenditionFinder(DocumentModel source, String renditionName) {
        super(source.getCoreSession());
        this.source = source;
        this.renditionName = renditionName;
    }

    public void run() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ecm:isProxy = 0 AND ");
        query.append("rend:renditionName");
        query.append(" = '");
        query.append(this.renditionName);
        query.append("' AND ");
        boolean isVersionable = this.source.isVersionable();
        String renditionSourceId = this.source.getId();
        if (isVersionable) {
            if (!this.source.isVersion() && !this.source.isCheckedOut()) {
                DocumentModel lastVersion = this.session.getLastDocumentVersion(this.source.getRef());
                if (lastVersion != null) {
                    renditionSourceId = lastVersion.getId();
                } else {
                    return;
                }
            }
            query.append("ecm:isCheckedInVersion = 1 AND ");
        } else {
            String modificationDatePropertyName = this.getSourceDocumentModificationDatePropertyName();
            Calendar sourceLastModified = (Calendar)this.source.getPropertyValue(modificationDatePropertyName);
            if (sourceLastModified != null) {
                query.append("rend:sourceModificationDate");
                query.append(" >= ");
                query.append(RenditionFinder.formatTimestamp(sourceLastModified));
                query.append(" AND ");
            }
        }
        query.append("rend:sourceId");
        query.append(" = '");
        query.append(renditionSourceId);
        query.append("' ORDER BY dc:modified DESC");
        DocumentModelList docs = this.session.query(query.toString());
        if (docs.size() > 0) {
            this.storedRendition = (DocumentModel)docs.get(0);
            this.storedRendition.detach(true);
        }
    }

    public DocumentModel getStoredRendition() {
        return this.storedRendition;
    }

    protected String getSourceDocumentModificationDatePropertyName() {
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = ((RenditionServiceImpl)rs).getRenditionDefinition(this.renditionName);
        return def.getSourceDocumentModificationDatePropertyName();
    }

    protected static String formatTimestamp(Calendar cal) {
        return new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss.SSS''").format(cal.getTime());
    }
}

