/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.impl.LiveRendition;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionCreator;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderDescriptor;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionFinder;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RenditionServiceImpl
extends DefaultComponent
implements RenditionService {
    public static final String RENDITION_DEFINITIONS_EP = "renditionDefinitions";
    public static final String RENDITON_DEFINION_PROVIDERS_EP = "renditionDefinitionProviders";
    private static final Log log = LogFactory.getLog(RenditionServiceImpl.class);
    @Deprecated
    protected AutomationService automationService;
    @Deprecated
    protected Map<String, RenditionDefinition> renditionDefinitions;
    protected RenditionDefinitionRegistry renditionDefinitionRegistry;
    protected RenditionDefinitionProviderRegistry renditionDefinitionProviderRegistry;

    public void activate(ComponentContext context) {
        this.renditionDefinitions = new HashMap<String, RenditionDefinition>();
        this.renditionDefinitionRegistry = new RenditionDefinitionRegistry();
        this.renditionDefinitionProviderRegistry = new RenditionDefinitionProviderRegistry();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.renditionDefinitions = null;
        this.renditionDefinitionRegistry = null;
        this.renditionDefinitionProviderRegistry = null;
        super.deactivate(context);
    }

    public RenditionDefinition getRenditionDefinition(String name) {
        return this.renditionDefinitionRegistry.getRenditionDefinition(name);
    }

    @Deprecated
    public List<RenditionDefinition> getDeclaredRenditionDefinitions() {
        return new ArrayList<RenditionDefinition>(this.renditionDefinitionRegistry.descriptors.values());
    }

    @Deprecated
    public List<RenditionDefinition> getDeclaredRenditionDefinitionsForProviderType(String providerType) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition def : this.getDeclaredRenditionDefinitions()) {
            if (!def.getProviderType().equals(providerType)) continue;
            defs.add(def);
        }
        return defs;
    }

    public List<RenditionDefinition> getAvailableRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        defs.addAll(this.renditionDefinitionRegistry.getRenditionDefinitions(doc));
        defs.addAll(this.renditionDefinitionProviderRegistry.getRenditionDefinitions(doc));
        return defs;
    }

    public DocumentRef storeRendition(DocumentModel source, String renditionDefinitionName) {
        Rendition rendition = this.getRendition(source, renditionDefinitionName, true);
        return rendition == null ? null : rendition.getHostDocument().getRef();
    }

    protected DocumentModel storeRendition(DocumentModel sourceDocument, Rendition rendition, String name) {
        if (!rendition.isCompleted()) {
            return null;
        }
        List renderedBlobs = rendition.getBlobs();
        Blob renderedBlob = (Blob)renderedBlobs.get(0);
        CoreSession session = sourceDocument.getCoreSession();
        DocumentModel version = null;
        boolean isVersionable = sourceDocument.isVersionable();
        if (isVersionable) {
            DocumentRef versionRef = this.createVersionIfNeeded(sourceDocument, session);
            version = session.getDocument(versionRef);
        }
        RenditionCreator rc = new RenditionCreator(session, sourceDocument, version, renderedBlob, name);
        rc.runUnrestricted();
        DocumentModel detachedRendition = rc.getDetachedRendition();
        detachedRendition.attach(sourceDocument.getSessionId());
        return detachedRendition;
    }

    protected DocumentRef createVersionIfNeeded(DocumentModel source, CoreSession session) {
        if (source.isVersionable()) {
            if (source.isVersion()) {
                return source.getRef();
            }
            if (source.isCheckedOut()) {
                DocumentRef versionRef = session.checkIn(source.getRef(), VersioningOption.MINOR, null);
                source.refresh(1, null);
                return versionRef;
            }
            return session.getLastDocumentVersionRef(source.getRef());
        }
        return null;
    }

    @Deprecated
    protected AutomationService getAutomationService() {
        return (AutomationService)Framework.getService(AutomationService.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            RenditionDefinition renditionDefinition = (RenditionDefinition)contribution;
            this.renditionDefinitionRegistry.addContribution(renditionDefinition);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.addContribution((RenditionDefinitionProviderDescriptor)contribution);
        }
    }

    @Deprecated
    protected void registerRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        if (name == null) {
            log.error((Object)"Cannot register rendition without a name");
            return;
        }
        boolean enabled = renditionDefinition.isEnabled();
        if (this.renditionDefinitions.containsKey(name)) {
            log.info((Object)("Overriding rendition with name: " + name));
            if (enabled) {
                renditionDefinition = this.mergeRenditions(this.renditionDefinitions.get(name), renditionDefinition);
            } else {
                log.info((Object)("Disabled rendition with name " + name));
                this.renditionDefinitions.remove(name);
            }
        }
        if (enabled) {
            log.info((Object)("Registering rendition with name: " + name));
            this.renditionDefinitions.put(name, renditionDefinition);
        }
        this.setupProvider(renditionDefinition);
    }

    @Deprecated
    protected void setupProvider(RenditionDefinition definition) {
        if (definition.getProviderClass() == null) {
            definition.setProvider((RenditionProvider)new DefaultAutomationRenditionProvider());
        } else {
            try {
                RenditionProvider provider = (RenditionProvider)definition.getProviderClass().newInstance();
                definition.setProvider(provider);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create RenditionProvider", (Throwable)e);
            }
        }
    }

    protected RenditionDefinition mergeRenditions(RenditionDefinition oldRenditionDefinition, RenditionDefinition newRenditionDefinition) {
        String operationChain;
        String label = newRenditionDefinition.getLabel();
        if (label != null) {
            oldRenditionDefinition.label = label;
        }
        if ((operationChain = newRenditionDefinition.getOperationChain()) != null) {
            oldRenditionDefinition.operationChain = operationChain;
        }
        return oldRenditionDefinition;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            this.renditionDefinitionRegistry.removeContribution((RenditionDefinition)contribution);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.removeContribution((RenditionDefinitionProviderDescriptor)contribution);
        }
    }

    @Deprecated
    protected void unregisterRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        this.renditionDefinitions.remove(name);
        log.info((Object)("Unregistering rendition with name: " + name));
    }

    public Rendition getRendition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, renditionDefinition.isStoreByDefault());
    }

    public Rendition getRendition(DocumentModel doc, String renditionName, boolean store) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, store);
    }

    protected Rendition getRendition(DocumentModel doc, RenditionDefinition renditionDefinition, boolean store) {
        DocumentModel stored = null;
        boolean isVersionable = doc.isVersionable();
        if (!isVersionable || !doc.isCheckedOut()) {
            RenditionFinder finder = new RenditionFinder(doc, renditionDefinition.getName());
            if (isVersionable) {
                finder.runUnrestricted();
            } else {
                finder.run();
            }
            stored = finder.getStoredRendition();
            if (stored != null) {
                stored.attach(doc.getCoreSession().getSessionId());
            }
        }
        if (stored != null) {
            return new StoredRendition(stored, renditionDefinition);
        }
        LiveRendition rendition = new LiveRendition(doc, renditionDefinition);
        if (store) {
            DocumentModel storedRenditionDoc = this.storeRendition(doc, (Rendition)rendition, renditionDefinition.getName());
            if (storedRenditionDoc != null) {
                return new StoredRendition(storedRenditionDoc, renditionDefinition);
            }
            return rendition;
        }
        return rendition;
    }

    protected RenditionDefinition getAvailableRenditionDefinition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.renditionDefinitionRegistry.getRenditionDefinition(renditionName);
        if (renditionDefinition == null && (renditionDefinition = this.renditionDefinitionProviderRegistry.getRenditionDefinition(renditionName, doc)) == null) {
            String message = "The rendition definition '%s' is not registered";
            throw new NuxeoException(String.format(message, renditionName));
        }
        if (!renditionDefinition.getProvider().isAvailable(doc, renditionDefinition)) {
            throw new NuxeoException("Rendition " + renditionName + " not available for this doc " + doc.getId());
        }
        return renditionDefinition;
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc) {
        return this.getAvailableRenditions(doc, false);
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc, boolean onlyVisible) {
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        if (doc.isProxy()) {
            return renditions;
        }
        List<RenditionDefinition> defs = this.getAvailableRenditionDefinitions(doc);
        if (defs != null) {
            for (RenditionDefinition def : defs) {
                Rendition rendition;
                if (onlyVisible && (!onlyVisible || !def.isVisible()) || (rendition = this.getRendition(doc, def.getName(), false)) == null) continue;
                renditions.add(rendition);
            }
        }
        return renditions;
    }
}

