/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.opencmis.bindings.DefaultErrorExtractor;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCmisErrorHelper {
    public static final String EXTRACTOR_CLASS_PROP = "org.nuxeo.cmis.errorextractor";
    public static ErrorExtractor errorExtractor;

    public static ErrorInfo extractError(Exception ex) {
        if (errorExtractor == null) {
            String className = Framework.getProperty((String)EXTRACTOR_CLASS_PROP);
            if (StringUtils.isBlank((String)className)) {
                className = DefaultErrorExtractor.class.getName();
            }
            try {
                errorExtractor = (ErrorExtractor)Class.forName(className).newInstance();
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new RuntimeException("Cannot instantiate " + className, e);
            }
        }
        return errorExtractor.extractError(ex);
    }

    public static class ErrorInfo {
        public int statusCode;
        public String exceptionName;
        public String message;

        public ErrorInfo(int statusCode, String exceptionName, String message) {
            this.statusCode = statusCode;
            this.exceptionName = exceptionName;
            this.message = message;
        }
    }

    public static interface ErrorExtractor {
        public ErrorInfo extractError(Exception var1);
    }
}

