/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.io.File;
import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.CallContextAwareCmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.CmisServiceWrapperManager;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisServiceWrapper;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepositories;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCmisServiceFactory
extends AbstractServiceFactory {
    public static final String PROP_TEMP_DIRECTORY = "service.tempDirectory";
    public static final String PROP_ENCRYPT_TEMP_FILES = "service.encryptTempFiles";
    public static final String PROP_MEMORY_THERESHOLD = "service.memoryThreshold";
    public static final String PROP_MAX_CONTENT_SIZE = "service.maxContentSize";
    public static final String PROP_DEFAULT_TYPES_MAX_ITEMS = "service.defaultTypesMaxItems";
    public static final String PROP_DEFAULT_TYPES_DEPTH = "service.defaultTypesDepth";
    public static final String PROP_DEFAULT_MAX_ITEMS = "service.defaultMaxItems";
    public static final String PROP_DEFAULT_DEPTH = "service.defaultDepth";
    public static final int DEFAULT_TYPES_MAX_ITEMS = 100;
    public static final int DEFAULT_TYPES_DEPTH = -1;
    public static final int DEFAULT_MAX_ITEMS = 100;
    public static final int DEFAULT_DEPTH = 2;
    protected CmisServiceWrapperManager wrapperManager;
    protected BigInteger defaultTypesMaxItems;
    protected BigInteger defaultTypesDepth;
    protected BigInteger defaultMaxItems;
    protected BigInteger defaultDepth;
    protected File tempDirectory;
    protected boolean encryptTempFiles;
    protected long memoryThreshold;
    protected long maxContentSize;

    public void init(Map<String, String> parameters) {
        this.initParameters(parameters);
        this.wrapperManager = new CmisServiceWrapperManager();
        this.wrapperManager.addWrappersFromServiceFactoryParameters(parameters);
        this.wrapperManager.addOuterWrapper(NuxeoCmisServiceWrapper.class, new Object[]{this.defaultTypesMaxItems, this.defaultTypesDepth, this.defaultMaxItems, this.defaultDepth});
    }

    protected void initParameters(Map<String, String> parameters) {
        String tempDirectoryStr = parameters.get(PROP_TEMP_DIRECTORY);
        this.tempDirectory = StringUtils.isBlank((String)tempDirectoryStr) ? super.getTempDirectory() : new File(tempDirectoryStr.trim());
        String encryptTempStr = parameters.get(PROP_ENCRYPT_TEMP_FILES);
        this.encryptTempFiles = StringUtils.isBlank((String)encryptTempStr) ? super.encryptTempFiles() : Boolean.parseBoolean(encryptTempStr.trim());
        this.memoryThreshold = NuxeoCmisServiceFactory.getLongParameter(parameters, PROP_MEMORY_THERESHOLD, super.getMemoryThreshold());
        this.maxContentSize = NuxeoCmisServiceFactory.getLongParameter(parameters, PROP_MAX_CONTENT_SIZE, Long.MAX_VALUE);
        this.defaultTypesMaxItems = NuxeoCmisServiceFactory.getBigIntegerParameter(parameters, PROP_DEFAULT_TYPES_MAX_ITEMS, 100);
        this.defaultTypesDepth = NuxeoCmisServiceFactory.getBigIntegerParameter(parameters, PROP_DEFAULT_TYPES_DEPTH, -1);
        this.defaultMaxItems = NuxeoCmisServiceFactory.getBigIntegerParameter(parameters, PROP_DEFAULT_MAX_ITEMS, 100);
        this.defaultDepth = NuxeoCmisServiceFactory.getBigIntegerParameter(parameters, PROP_DEFAULT_DEPTH, 2);
    }

    protected static long getLongParameter(Map<String, String> parameters, String key, long def) {
        String value = parameters.get(key);
        try {
            return StringUtils.isBlank((String)value) ? def : Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new CmisRuntimeException("Could not parse configuration values for " + key + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected static BigInteger getBigIntegerParameter(Map<String, String> parameters, String key, int def) {
        String value = parameters.get(key);
        try {
            return StringUtils.isBlank((String)value) ? BigInteger.valueOf(def) : new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new CmisRuntimeException("Could not parse configuration values for " + key + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public CmisService getService(CallContext context) {
        String repositoryId = context.getRepositoryId();
        if (StringUtils.isBlank((String)repositoryId)) {
            repositoryId = null;
        } else {
            NuxeoRepository repository = ((NuxeoRepositories)Framework.getService(NuxeoRepositories.class)).getRepository(repositoryId);
            if (repository == null) {
                throw new CmisInvalidArgumentException("No such repository: " + repositoryId);
            }
        }
        NuxeoCmisService nuxeoCmisService = new NuxeoCmisService(repositoryId);
        CallContextAwareCmisService service = (CallContextAwareCmisService)this.wrapperManager.wrap((CmisService)nuxeoCmisService);
        service.setCallContext(context);
        return service;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public boolean encryptTempFiles() {
        return this.encryptTempFiles;
    }

    public int getMemoryThreshold() {
        return (int)this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }
}

