/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionPropertiesDescriptor;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.runtime.api.Framework;

@XObject(value="action")
public class Action
implements Serializable,
Cloneable,
Comparable<Action> {
    public static final String[] EMPTY_CATEGORIES = new String[0];
    private static final long serialVersionUID = 1L;
    @XNode(value="@id")
    protected String id = "";
    protected String link = null;
    @Deprecated
    @XNodeList(value="link-params/param", type=Class[].class, componentType=Class.class)
    private Class<?>[] linkParams;
    @XNode(value="@enabled")
    protected Boolean enabled;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@icon")
    protected String icon;
    @XNode(value="@confirm")
    protected String confirm;
    @XNode(value="@help")
    protected String help;
    @XNode(value="@immediate")
    protected Boolean immediate;
    @XNode(value="@accessKey")
    protected String accessKey;
    @XNode(value="@type")
    protected String type = null;
    @XNode(value="properties")
    protected ActionPropertiesDescriptor properties;
    protected Map<String, Serializable> localProperties;
    protected Map<String, Serializable> propertiesCache;
    protected boolean available = true;
    @XNode(value="@order")
    protected int order = 0;
    @XNodeList(value="category", type=String[].class, componentType=String.class)
    protected String[] categories = EMPTY_CATEGORIES;
    @XNodeList(value="filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;
    @XNodeList(value="filter", type=ActionFilter[].class, componentType=DefaultActionFilter.class)
    protected ActionFilter[] filters;

    public Action() {
    }

    public Action(String id, String[] categories) {
        this.id = id;
        this.categories = categories;
    }

    public boolean isEnableSet() {
        return this.enabled != null;
    }

    public boolean isEnabled() {
        return this.enabled == null || Boolean.TRUE.equals(this.enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected String getStringProperty(String prop) {
        Serializable obj;
        Map<String, Serializable> props = this.getProperties();
        if (props != null && props.containsKey(prop) && (obj = props.get(prop)) instanceof String) {
            return (String)((Object)obj);
        }
        return null;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getStringProperty("label");
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getIcon() {
        if (this.icon == null) {
            return this.getStringProperty("icon");
        }
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLink() {
        if (this.link == null) {
            return this.getStringProperty("link");
        }
        return this.link;
    }

    @XNode(value="@link")
    public void setLink(String link) {
        if (link != null) {
            this.link = Framework.expandVars((String)link);
        }
    }

    public String[] getCategories() {
        return this.categories;
    }

    public List<String> getCategoryList() {
        if (this.categories == null) {
            return null;
        }
        return Arrays.asList(this.categories);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int compareTo(Action anotherAction) {
        int cmp = this.order - anotherAction.order;
        if (cmp == 0) {
            cmp = this.id.compareTo(anotherAction.id);
        }
        return cmp;
    }

    public List<String> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds = filterIds;
    }

    public ActionFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(ActionFilter[] filters) {
        this.filters = filters;
    }

    public void setCategories(String[] categories) {
        this.categories = categories;
    }

    @Deprecated
    public Class[] getLinkParams() {
        return this.linkParams;
    }

    @Deprecated
    public void setLinkParams(Class<?>[] linkParams) {
        this.linkParams = linkParams;
    }

    public String getConfirm() {
        if (this.confirm == null) {
            String conf = this.getStringProperty("confirm");
            if (conf == null) {
                conf = "";
            }
            return conf;
        }
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public String getHelp() {
        if (this.help == null) {
            String conf = this.getStringProperty("help");
            if (conf == null) {
                conf = "";
            }
            return conf;
        }
        return this.help;
    }

    public void setHelp(String title) {
        this.help = title;
    }

    public boolean isImmediate() {
        if (this.immediate == null) {
            Map<String, Serializable> props = this.getProperties();
            if (props != null && props.containsKey("immediate")) {
                Serializable obj = props.get("immediate");
                if (obj instanceof String) {
                    return Boolean.valueOf((String)((Object)obj));
                }
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
            }
            return false;
        }
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ActionPropertiesDescriptor getPropertiesDescriptor() {
        return this.properties;
    }

    public void setPropertiesDescriptor(ActionPropertiesDescriptor properties) {
        this.properties = properties;
        this.propertiesCache = null;
    }

    public void setProperties(Map<String, Serializable> localProperties) {
        this.localProperties = localProperties;
        this.propertiesCache = null;
    }

    public Map<String, Serializable> getProperties() {
        if (this.propertiesCache == null) {
            this.propertiesCache = new HashMap<String, Serializable>();
            if (this.properties != null) {
                this.propertiesCache.putAll(this.properties.getAllProperties());
            }
            if (this.localProperties != null) {
                this.propertiesCache.putAll(this.localProperties);
            }
        }
        return this.propertiesCache;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKey() {
        if (this.accessKey == null) {
            return this.getStringProperty("accessKey");
        }
        return this.accessKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Action)) {
            return false;
        }
        Action otherAction = (Action)other;
        return this.id == null ? otherAction.id == null : this.id.equals(otherAction.id);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public Action clone() {
        Action clone = new Action();
        clone.id = this.id;
        clone.link = this.link;
        if (this.linkParams != null) {
            clone.linkParams = (Class[])this.linkParams.clone();
        }
        clone.enabled = this.enabled;
        clone.label = this.label;
        clone.icon = this.icon;
        clone.confirm = this.confirm;
        clone.help = this.help;
        clone.immediate = this.immediate;
        clone.accessKey = this.accessKey;
        clone.type = this.type;
        if (this.properties != null) {
            clone.properties = this.properties.clone();
        }
        clone.available = this.available;
        clone.order = this.order;
        if (this.categories != null) {
            clone.categories = (String[])this.categories.clone();
        }
        if (this.filterIds != null) {
            clone.filterIds = new ArrayList<String>(this.filterIds);
        }
        if (this.filters != null) {
            clone.filters = new ActionFilter[this.filters.length];
            for (int i = 0; i < this.filters.length; ++i) {
                clone.filters[i] = this.filters[i].clone();
            }
        }
        return clone;
    }
}

