/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionContributionHandler;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.FilterContributionHandler;
import org.nuxeo.ecm.platform.actions.FilterFactory;
import org.nuxeo.ecm.platform.actions.TypeCompatibility;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class ActionService
extends DefaultComponent
implements ActionManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.actions.ActionService");
    private static final long serialVersionUID = -5256555810901945824L;
    private static final Log log = LogFactory.getLog(ActionService.class);
    private ActionContributionHandler actions;
    private FilterContributionHandler filters;

    public void activate(ComponentContext context) {
        this.filters = new FilterContributionHandler();
        this.actions = new ActionContributionHandler(this.filters);
    }

    public void deactivate(ComponentContext context) {
        this.actions = null;
        this.filters = null;
    }

    @Deprecated
    public final ActionRegistry getActionRegistry() {
        return this.actions.getRegistry();
    }

    @Deprecated
    public final ActionFilterRegistry getFilterRegistry() {
        return this.filters.getRegistry();
    }

    private void applyFilters(ActionContext context, List<Action> actions) {
        Iterator<Action> it = actions.iterator();
        while (it.hasNext()) {
            Action action = it.next();
            if (this.checkFilters(context, action)) continue;
            it.remove();
        }
    }

    private boolean checkFilters(ActionContext context, Action action) {
        boolean granted;
        if (action == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Checking access for action '%s'...", action.getId()));
        }
        if (granted = this.checkFilters(action, action.getFilterIds(), context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Granting access for action '%s'", action.getId()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Denying access for action '%s'", action.getId()));
        }
        return granted;
    }

    @Override
    public List<Action> getActions(String category, ActionContext context) {
        return this.getActions(category, context, true);
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.getActionRegistry().getActions(category);
    }

    @Override
    public List<Action> getActions(String category, ActionContext context, boolean hideUnavailableActions) {
        List<Action> actions = this.getActionRegistry().getActions(category);
        if (hideUnavailableActions) {
            this.applyFilters(context, actions);
            return actions;
        }
        ArrayList<Action> allActions = new ArrayList<Action>();
        allActions.addAll(actions);
        this.applyFilters(context, actions);
        for (Action a : allActions) {
            a.setAvailable(actions.contains(a));
        }
        return allActions;
    }

    @Override
    public Action getAction(String actionId, ActionContext context, boolean hideUnavailableAction) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action != null) {
            if (hideUnavailableAction) {
                if (!this.checkFilters(context, action)) {
                    return null;
                }
            } else if (!this.checkFilters(context, action)) {
                action.setAvailable(false);
            }
        }
        return action;
    }

    @Override
    public Action getAction(String actionId) {
        return this.getActionRegistry().getAction(actionId);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.getActionRegistry().getAction(actionId) != null;
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action != null) {
            return this.isEnabled(action, context);
        }
        return false;
    }

    public boolean isEnabled(Action action, ActionContext context) {
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        for (String filterId : action.getFilterIds()) {
            ActionFilter filter = filterReg.getFilter(filterId);
            if (filter == null || filter.accept(action, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action == null) {
            return null;
        }
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        List<String> filterIds = action.getFilterIds();
        if (filterIds != null && !filterIds.isEmpty()) {
            ActionFilter[] filters = new ActionFilter[filterIds.size()];
            for (int i = 0; i < filters.length; ++i) {
                String filterId = filterIds.get(i);
                filters[i] = filterReg.getFilter(filterId);
            }
            return filters;
        }
        return null;
    }

    @Override
    public boolean checkFilter(String filterId, ActionContext context) {
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        ActionFilter filter = filterReg.getFilter(filterId);
        if (filter == null) {
            return false;
        }
        return filter.accept(null, context);
    }

    @Override
    public boolean checkFilters(List<String> filterIds, ActionContext context) {
        return this.checkFilters(null, filterIds, context);
    }

    protected boolean checkFilters(Action action, List<String> filterIds, ActionContext context) {
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        for (String filterId : filterIds) {
            ActionFilter filter = filterReg.getFilter(filterId);
            if (filter == null) continue;
            if (!filter.accept(action, context)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Filter '%s' denied access", filterId));
                }
                return false;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Filter '%s' granted access", filterId));
        }
        return true;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("actions".equals(extensionPoint)) {
            this.actions.addContribution((Action)contribution);
        } else if ("filters".equals(extensionPoint)) {
            if (contribution.getClass() == FilterFactory.class) {
                this.registerFilterFactory((FilterFactory)contribution);
            } else {
                this.filters.addContribution((DefaultActionFilter)contribution);
            }
        } else if ("typeCompatibility".equals(extensionPoint)) {
            this.actions.getRegistry().getTypeCategoryRelations().add((TypeCompatibility)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("actions".equals(extensionPoint)) {
            this.actions.removeContribution((Action)contribution);
        } else if ("filters".equals(extensionPoint)) {
            if (contribution.getClass() == FilterFactory.class) {
                this.unregisterFilterFactory((FilterFactory)contribution);
            } else {
                this.filters.removeContribution((DefaultActionFilter)contribution);
            }
        }
    }

    @Deprecated
    protected void registerFilterFactory(FilterFactory ff) {
        this.getFilterRegistry().removeFilter(ff.id);
        try {
            ActionFilter filter = (ActionFilter)Thread.currentThread().getContextClassLoader().loadClass(ff.className).newInstance();
            filter.setId(ff.id);
            this.getFilterRegistry().addFilter(filter);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"Failed to create action filter", (Throwable)e);
        }
    }

    @Deprecated
    public void unregisterFilterFactory(FilterFactory ff) {
        this.getFilterRegistry().removeFilter(ff.id);
    }

    @Override
    public void remove() {
    }
}

