/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.faces.facelets.tag.TagAttributesImpl;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinWidgetModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.ui.web.component.file.UIInputFile;
import org.nuxeo.ecm.platform.ui.web.component.file.UIOutputFile;
import org.nuxeo.ecm.platform.ui.web.component.seam.UIHtmlText;

public class FileWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final long serialVersionUID = 1495841177711755669L;

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers) throws WidgetException {
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, tagConfig);
        String mode = widget.getMode();
        String widgetId = widget.getId();
        String widgetName = widget.getName();
        String widgetTagConfigId = widget.getTagConfigId();
        TagAttributes attributes = BuiltinWidgetModes.isLikePlainMode((String)mode) ? helper.getTagAttributes(widget) : helper.getTagAttributes(widgetId, widget);
        FieldDefinition[] fields = widget.getFieldDefinitions();
        if (fields != null && fields.length > 1) {
            FieldDefinition filenameField = fields[1];
            TagAttribute filenameAttr = helper.createAttribute("filename", ValueExpressionHelper.createExpressionString(widget.getValueName(), filenameField));
            attributes = FaceletHandlerHelper.addTagAttribute(attributes, filenameAttr);
        }
        boolean isEdit = "edit".equals(mode);
        FaceletHandler leaf = this.getNextHandler(ctx, tagConfig, widget, subHandlers, helper, false, isEdit);
        if (isEdit) {
            ComponentHandler input = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, UIInputFile.COMPONENT_TYPE, null);
            String msgId = helper.generateMessageId(widgetName);
            ComponentHandler message = helper.getMessageComponentHandler(widgetTagConfigId, msgId, widgetId, null);
            FaceletHandler[] handlers = new FaceletHandler[]{input, message};
            return new CompositeFaceletHandler(handlers);
        }
        ComponentHandler output = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, UIOutputFile.COMPONENT_TYPE, null);
        if ("pdf".equals(mode)) {
            return helper.getHtmlComponentHandler(widgetTagConfigId, (TagAttributes)new TagAttributesImpl(new TagAttribute[0]), (FaceletHandler)output, UIHtmlText.class.getName(), null);
        }
        return output;
    }
}

