/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ExtractImages {
    private int imageCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";
    private static final String ADDKEY = "-addkey";
    private static final String NONSEQ = "-nonSeq";
    private static final String DIRECTJPEG = "-directJPEG";
    private static final List<String> DCT_FILTERS = new ArrayList<String>();

    private ExtractImages() {
    }

    public static void main(String[] args) throws Exception {
        ExtractImages extractor = new ExtractImages();
        extractor.extractImages(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractImages(String[] args) throws Exception {
        if (args.length < 1 || args.length > 4) {
            ExtractImages.usage();
            return;
        }
        String pdfFile = null;
        String password = "";
        String prefix = null;
        boolean addKey = false;
        boolean useNonSeqParser = false;
        boolean directJPEG = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractImages.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PREFIX)) {
                if (++i >= args.length) {
                    ExtractImages.usage();
                }
                prefix = args[i];
                continue;
            }
            if (args[i].equals(ADDKEY)) {
                addKey = true;
                continue;
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (args[i].equals(DIRECTJPEG)) {
                directJPEG = true;
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            ExtractImages.usage();
            return;
        }
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        PDDocument document = null;
        try {
            if (useNonSeqParser) {
                document = PDDocument.loadNonSeq(new File(pdfFile), null, password);
            } else {
                document = PDDocument.load(pdfFile);
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial spm = new StandardDecryptionMaterial(password);
                    document.openProtection(spm);
                }
            }
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canExtractContent()) {
                throw new IOException("Error: You do not have permission to extract images.");
            }
            List pages = document.getDocumentCatalog().getAllPages();
            for (PDPage page : pages) {
                PDResources resources = page.getResources();
                this.processResources(resources, prefix, addKey, directJPEG);
            }
            Object var15_15 = null;
            if (document == null) return;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeJpeg2file(PDJpeg image, String filename) throws IOException {
        FileOutputStream out = null;
        try {
            int amountRead;
            out = new FileOutputStream(filename + ".jpg");
            InputStream data = image.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
            byte[] buf = new byte[1024];
            while ((amountRead = data.read(buf)) != -1) {
                out.write(buf, 0, amountRead);
            }
            IOUtils.closeQuietly(data);
            out.flush();
            Object var8_7 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private void processResources(PDResources resources, String prefix, boolean addKey, boolean directJPEG) throws IOException {
        if (resources == null) {
            return;
        }
        Map<String, PDXObject> xobjects = resources.getXObjects();
        if (xobjects != null) {
            for (String key : xobjects.keySet()) {
                PDXObject xobject = xobjects.get(key);
                if (xobject instanceof PDXObjectImage) {
                    PDXObjectImage image = (PDXObjectImage)xobject;
                    String name = null;
                    name = addKey ? this.getUniqueFileName(prefix + "_" + key, image.getSuffix()) : this.getUniqueFileName(prefix, image.getSuffix());
                    System.out.println("Writing image:" + name);
                    if (directJPEG && "jpg".equals(image.getSuffix())) {
                        this.writeJpeg2file((PDJpeg)image, name);
                    } else {
                        image.write2file(name);
                    }
                    image.clear();
                    continue;
                }
                if (!(xobject instanceof PDXObjectForm)) continue;
                PDXObjectForm xObjectForm = (PDXObjectForm)xobject;
                PDResources formResources = xObjectForm.getResources();
                this.processResources(formResources, prefix, addKey, directJPEG);
            }
        }
        resources.clear();
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.ExtractImages [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -prefix  <image-prefix>      Image prefix(default to pdf name)\n  -addkey                      add the internal image key to the file name\n  -nonSeq                      Enables the new non-sequential parser\n  -directJPEG                  Forces the direct extraction of JPEG images regardless of colorspace\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }

    static {
        DCT_FILTERS.add(COSName.DCT_DECODE.getName());
        DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
    }
}

