/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.operations;

import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.SetMetadataFromBlob", category="Files", label="Trigger Metadata Mapping", description="Write Metadata To Document From Binary according to metadata mapping.", since="7.1", addToStudio=true, aliases={"Document.TriggerMetadataMapping"})
public class TriggerMetadataMappingOnDocument {
    public static final String ID = "Document.SetMetadataFromBlob";
    @Context
    protected BinaryMetadataService binaryMetadataService;
    @Context
    protected OperationContext operationContext;
    @Param(name="processor", required=false, description="The processor to execute for reading blobs metadata.")
    protected String processor = "exifTool";
    @Param(name="metadataMappingId", required=true, description="The metadata mapping id to apply on the input document.")
    protected String metadataMappingId;

    @OperationMethod
    public void run(DocumentModel document) {
        this.binaryMetadataService.writeMetadata(document, this.operationContext.getCoreSession(), this.metadataMappingId);
    }
}

