/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent.internal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaQueue<T> {
    private Node<T> head = null;

    public boolean isEmpty() {
        return this.head == null;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public T next() {
        return this.head.value;
    }

    public long delay() {
        return this.head.delay;
    }

    public void add(long delay, T value) {
        Node<T> newNode = new Node<T>(value, delay);
        Node<T> prev = null;
        Node<T> next = this.head;
        while (next != null && next.delay <= newNode.delay) {
            newNode.delay -= next.delay;
            prev = next;
            next = next.next;
        }
        if (prev == null) {
            this.head = newNode;
        } else {
            prev.next = newNode;
        }
        if (next != null) {
            next.delay -= newNode.delay;
            newNode.next = next;
        }
    }

    public long tick(long timeUnits) {
        if (this.head == null) {
            return 0L;
        }
        if (this.head.delay >= timeUnits) {
            this.head.delay -= timeUnits;
            return 0L;
        }
        long leftover = timeUnits - this.head.delay;
        this.head.delay = 0L;
        return leftover;
    }

    public T pop() {
        if (this.head.delay > 0L) {
            throw new IllegalStateException("cannot pop the head element when it has a non-zero delay");
        }
        Object popped = this.head.value;
        this.head = this.head.next;
        return popped;
    }

    public boolean remove(T element) {
        Node<T> prev = null;
        Node<T> node = this.head;
        while (node != null && node.value != element) {
            prev = node;
            node = node.next;
        }
        if (node == null) {
            return false;
        }
        if (node.next != null) {
            node.next.delay += node.delay;
        }
        if (prev == null) {
            this.head = node.next;
        } else {
            prev.next = node.next;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        Node<T> node = this.head;
        while (node != null) {
            if (node != this.head) {
                sb.append(", ");
            }
            sb.append("+").append(node.delay).append(": ").append(node.value);
            node = node.next;
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        public final T value;
        public long delay;
        public Node<T> next = null;

        public Node(T value, long nanos) {
            this.value = value;
            this.delay = nanos;
        }
    }
}

