/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.ITextComponent;

public class UITable
extends ITextComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.pdf.ui.UITable";
    PdfPTable table;
    String widths;
    int columns = 1;
    Integer headerRows = 0;
    Integer footerRows = 0;
    Float widthPercentage;
    Integer horizontalAlignment;
    Boolean skipFirstHeader;
    Integer runDirection;
    Boolean lockedWidth;
    Boolean splitRows;
    Float spacingBefore;
    Float spacingAfter;
    Boolean extendLastRow;
    Boolean headersInEvent;
    Boolean splitLate;
    Boolean keepTogether;

    public void setWidths(String widths) {
        this.widths = widths;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setHeaderRows(Integer headerRows) {
        this.headerRows = headerRows;
    }

    public void setFooterRows(Integer footerRows) {
        this.footerRows = footerRows;
    }

    public void setExtendLastRow(Boolean extendLastRow) {
        this.extendLastRow = extendLastRow;
    }

    public void setHeadersInEvent(Boolean headersInEvent) {
        this.headersInEvent = headersInEvent;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = ITextUtils.alignmentValue(horizontalAlignment);
    }

    public void setKeepTogether(Boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    public void setLockedWidth(Boolean lockedWidth) {
        this.lockedWidth = lockedWidth;
    }

    public void setRunDirection(Integer runDirection) {
        this.runDirection = runDirection;
    }

    public void setSkipFirstHeader(Boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
    }

    public void setSpacingAfter(Float spacingAfter) {
        this.spacingAfter = spacingAfter;
    }

    public void setSpacingBefore(Float spacingBefore) {
        this.spacingBefore = spacingBefore;
    }

    public void setSplitLate(Boolean splitLate) {
        this.splitLate = splitLate;
    }

    public void setSplitRows(Boolean splitRows) {
        this.splitRows = splitRows;
    }

    public void setTable(PdfPTable table) {
        this.table = table;
    }

    public void setWidthPercentage(Float widthPercentage) {
        this.widthPercentage = widthPercentage;
    }

    @Override
    public Object getITextObject() {
        return this.table;
    }

    @Override
    public void removeITextObject() {
        this.table = null;
    }

    @Override
    public void createITextObject(FacesContext context) {
        this.columns = (Integer)this.valueBinding(context, "columns", this.columns);
        this.table = new PdfPTable(this.columns);
        this.widths = (String)this.valueBinding(context, "widths", this.widths);
        if (this.widths != null) {
            try {
                this.table.setWidths(ITextUtils.stringToFloatArray(this.widths));
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }
        this.headerRows = (Integer)this.valueBinding(context, "headerRows", this.headerRows);
        if (this.headerRows != null) {
            this.table.setHeaderRows(this.headerRows.intValue());
        }
        this.footerRows = (Integer)this.valueBinding(context, "footerRows", this.footerRows);
        if (this.footerRows != null) {
            this.table.setFooterRows(this.footerRows.intValue());
        }
        this.widthPercentage = (Float)this.valueBinding(context, "widthPercentage", this.widthPercentage);
        if (this.widthPercentage != null) {
            this.table.setWidthPercentage(this.widthPercentage.floatValue());
        }
        this.horizontalAlignment = (Integer)this.valueBinding(context, "horizontalAlignment", this.horizontalAlignment);
        if (this.horizontalAlignment != null) {
            this.table.setHorizontalAlignment(this.horizontalAlignment.intValue());
        }
        this.runDirection = (Integer)this.valueBinding(context, "runDirection", this.runDirection);
        if (this.runDirection != null) {
            this.table.setRunDirection(this.runDirection.intValue());
        }
        this.lockedWidth = (Boolean)this.valueBinding(context, "lockedWidth", this.lockedWidth);
        if (this.lockedWidth != null) {
            this.table.setLockedWidth(this.lockedWidth.booleanValue());
        }
        this.splitRows = (Boolean)this.valueBinding(context, "splitRows", this.splitRows);
        if (this.splitRows != null) {
            this.table.setSplitRows(this.splitRows.booleanValue());
        }
        this.spacingBefore = (Float)this.valueBinding(context, "spacingBefore", this.spacingBefore);
        if (this.spacingBefore != null) {
            this.table.setSpacingBefore(this.spacingBefore.floatValue());
        }
        this.spacingAfter = (Float)this.valueBinding(context, "spacingAfter", this.spacingAfter);
        if (this.spacingAfter != null) {
            this.table.setSpacingAfter(this.spacingAfter.floatValue());
        }
        this.extendLastRow = (Boolean)this.valueBinding(context, "extendLastRow", this.extendLastRow);
        if (this.extendLastRow != null) {
            this.table.setExtendLastRow(this.extendLastRow.booleanValue());
        }
        this.headersInEvent = (Boolean)this.valueBinding(context, "headersInEvent", this.headersInEvent);
        if (this.headersInEvent != null) {
            this.table.setHeadersInEvent(this.headersInEvent.booleanValue());
        }
        this.splitLate = (Boolean)this.valueBinding(context, "splitLate", this.splitLate);
        if (this.splitLate != null) {
            this.table.setSplitLate(this.splitLate.booleanValue());
        }
        this.keepTogether = (Boolean)this.valueBinding(context, "keepTogether", this.keepTogether);
        if (this.keepTogether != null) {
            this.table.setKeepTogether(this.keepTogether.booleanValue());
        }
    }

    @Override
    public void handleAdd(Object o) {
        if (o instanceof PdfPCell) {
            this.table.addCell((PdfPCell)o);
        } else if (o instanceof PdfPTable) {
            this.table.addCell((PdfPTable)o);
        } else if (o instanceof Phrase) {
            this.table.addCell((Phrase)o);
        } else if (o instanceof Image) {
            this.table.addCell((Image)o);
        } else {
            throw new RuntimeException("Can't add " + o.getClass().getName() + " to table");
        }
    }

    public PdfPCell getDefaultCellFacet() {
        Object facet = this.processFacet("defaultCell");
        if (facet != null) {
            if (!(facet instanceof PdfPCell)) {
                throw new RuntimeException("UITable defaultCell facet must be a PdfPCell - found " + facet.getClass());
            }
            return (PdfPCell)facet;
        }
        return null;
    }
}

