/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.task.event;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.task.CreateTask;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class TaskEndedEventListener
implements EventListener {
    private static final Log log = LogFactory.getLog(TaskEndedEventListener.class);

    public void handleEvent(Event event) {
        EventContext eventContext = event.getContext();
        Task.optionalTask((EventContext)eventContext).ifPresent(task -> this.handleTask(eventContext, (Task)task));
    }

    private void handleTask(EventContext eventContext, Task task) {
        Boolean validated = Boolean.valueOf(task.getVariable(TaskService.VariableName.validated.name()));
        String chain = validated != false ? task.getVariable(CreateTask.OperationTaskVariableName.acceptOperationChain.name()) : task.getVariable(CreateTask.OperationTaskVariableName.rejectOperationChain.name());
        if (!StringUtils.isEmpty((String)chain)) {
            try {
                AutomationService os = (AutomationService)Framework.getService(AutomationService.class);
                OperationContext ctx = new OperationContext(eventContext.getCoreSession());
                if (eventContext instanceof DocumentEventContext) {
                    ctx.setInput((Object)((DocumentEventContext)eventContext).getSourceDocument());
                    ctx.put(CreateTask.OperationTaskVariableName.taskDocument.name(), (Object)task.getDocument());
                }
                try {
                    os.run(ctx, chain);
                }
                catch (InvalidChainException e) {
                    log.error((Object)("Unknown chain: " + chain));
                }
            }
            catch (OperationException t) {
                log.error((Object)t, (Throwable)t);
            }
        }
    }
}

