/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.osgi.framework.Bundle;
import redis.clients.jedis.Jedis;

public class RedisComponent
extends DefaultComponent
implements RedisAdmin {
    private static final String DEFAULT_PREFIX = "nuxeo:";
    protected volatile RedisExecutor executor = RedisExecutor.NOOP;
    protected RedisPoolDescriptorRegistry registry = new RedisPoolDescriptorRegistry();
    protected String delsha;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.registry.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!(contribution instanceof RedisPoolDescriptor)) {
            throw new NuxeoException("Unknown contribution class: " + contribution);
        }
        this.registerRedisPoolDescriptor((RedisPoolDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof RedisPoolDescriptor) {
            this.unregisterRedisPoolDescriptor((RedisPoolDescriptor)contribution);
        }
    }

    public void registerRedisPoolDescriptor(RedisPoolDescriptor contrib) {
        this.registry.addContribution(contrib);
    }

    public void unregisterRedisPoolDescriptor(RedisPoolDescriptor contrib) {
        this.registry.removeContribution(contrib);
    }

    public RedisPoolDescriptor getConfig() {
        return this.registry.getConfig();
    }

    public void applicationStarted(ComponentContext context) {
        RedisPoolDescriptor config = this.getConfig();
        if (config == null || config.disabled) {
            return;
        }
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 2) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                try {
                    RedisComponent.this.executor.getPool().destroy();
                }
                finally {
                    RedisComponent.this.executor = null;
                }
            }
        });
        this.handleNewExecutor(config.newExecutor());
    }

    public int getApplicationStartedOrder() {
        return ((DefaultComponent)Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.work.service").getInstance()).getApplicationStartedOrder() - 1;
    }

    public void handleNewExecutor(RedisExecutor executor) {
        this.executor = executor;
        try {
            this.delsha = this.load("org.nuxeo.ecm.core.redis", "del-keys");
        }
        catch (IOException cause) {
            executor = null;
            throw new NuxeoException("Cannot activate redis executor", (Throwable)cause);
        }
    }

    @Override
    public Long clear(final String pattern) {
        return this.executor.execute(new RedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                List<String> keys = Arrays.asList(pattern);
                List<String> args = Arrays.asList(new String[0]);
                return (Long)jedis.evalsha(RedisComponent.this.delsha, keys, args);
            }
        });
    }

    @Override
    public String load(String bundleName, String scriptName) throws IOException {
        Bundle b = Framework.getRuntime().getBundle(bundleName);
        URL loc = b.getEntry(scriptName + ".lua");
        InputStream is = loc.openStream();
        final StrBuilder builder = new StrBuilder();
        for (String line : IOUtils.readLines((InputStream)is)) {
            builder.appendln(line);
        }
        return this.executor.execute(new RedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                return jedis.scriptLoad(builder.toString());
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RedisExecutor.class)) {
            return adapter.cast(this.executor);
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public String namespace(String ... names) {
        String prefix;
        RedisPoolDescriptor config = this.getConfig();
        String string = prefix = config == null ? null : config.prefix;
        if (StringUtils.isBlank((String)prefix)) {
            prefix = DEFAULT_PREFIX;
        }
        StringBuilder builder = new StringBuilder(prefix);
        for (String name : names) {
            builder.append(name).append(":");
        }
        return builder.toString();
    }

    public static class RedisPoolDescriptorRegistry
    extends SimpleContributionRegistry<RedisPoolDescriptor> {
        protected RedisPoolDescriptor config;

        public String getContributionId(RedisPoolDescriptor contrib) {
            return "main";
        }

        public void contributionUpdated(String id, RedisPoolDescriptor contrib, RedisPoolDescriptor newOrigContrib) {
            this.config = contrib;
        }

        public void contributionRemoved(String id, RedisPoolDescriptor origContrib) {
            this.config = null;
        }

        public RedisPoolDescriptor getConfig() {
            return this.config;
        }

        public void clear() {
            this.config = null;
        }
    }
}

