/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

@XObject(value="server")
public class RedisServerDescriptor
extends RedisPoolDescriptor {
    private static final Log log = LogFactory.getLog(RedisServerDescriptor.class);
    @XNode(value="host")
    public String host;
    @XNode(value="port")
    public int port = 6379;

    protected boolean canConnect(String name, int port) {
        try (Jedis jedis = new Jedis(name, port);){
            if (StringUtils.isNotBlank((String)this.password)) {
                jedis.auth(this.password);
            }
            boolean bl = this.canPing(jedis);
            return bl;
        }
    }

    protected boolean canPing(Jedis jedis) {
        try {
            String pong = jedis.ping();
            return "PONG".equals(pong);
        }
        catch (JedisException cause) {
            log.debug((Object)"Exception during ping", (Throwable)cause);
            return false;
        }
    }

    @Override
    public RedisExecutor newExecutor() {
        if (!this.canConnect(this.host, this.port)) {
            throw new NuxeoException("Cannot connect to Jedis host: " + this.host + ":" + this.port);
        }
        return new RedisPoolExecutor((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, StringUtils.defaultIfBlank((String)this.password, null), this.database));
    }
}

