/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.time.LocalDateTime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.contribs.RedisInvalidations;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;

public class RedisClusterInvalidator
implements ClusterInvalidator {
    protected static final String PREFIX = "inval";
    protected static final String INVALIDATION_CHANNEL = "channel";
    protected static final String CLUSTER_NODES_KEY = "nodes";
    protected static final int TIMEOUT_REGISTER_SECOND = 86400;
    protected static final String STARTED_KEY = "started";
    protected static final String LAST_INVAL_KEY = "lastInvalSent";
    protected String nodeId;
    protected String repositoryName;
    protected RedisExecutor redisExecutor;
    protected Invalidations receivedInvals;
    protected Thread subscriberThread;
    protected String namespace;
    protected String startedDateTime;
    private static final Log log = LogFactory.getLog(RedisClusterInvalidator.class);

    public void initialize(String nodeId, RepositoryImpl repository) {
        this.nodeId = nodeId;
        this.repositoryName = repository.getName();
        this.redisExecutor = (RedisExecutor)Framework.getLocalService(RedisExecutor.class);
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.namespace = redisAdmin.namespace(PREFIX, this.repositoryName);
        this.receivedInvals = new Invalidations();
        this.createSubscriberThread();
        this.registerNode();
    }

    protected void createSubscriberThread() {
        String name = "RedisClusterInvalidatorSubscriber:" + this.repositoryName + ":" + this.nodeId;
        this.subscriberThread = new Thread(this::subscribeToInvalidationChannel, name);
        this.subscriberThread.setUncaughtExceptionHandler((t, e) -> log.error((Object)("Uncaught error on thread " + t.getName()), e));
        this.subscriberThread.setPriority(5);
        this.subscriberThread.start();
    }

    protected void subscribeToInvalidationChannel() {
        log.info((Object)("Subscribe to channel: " + this.getChannelName()));
        this.redisExecutor.execute(jedis -> {
            jedis.subscribe(new JedisPubSub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(String channel, String message) {
                    try {
                        RedisInvalidations rInvals = new RedisInvalidations(RedisClusterInvalidator.this.nodeId, message);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Receive invalidations: " + rInvals));
                        }
                        Invalidations invals = rInvals.getInvalidations();
                        RedisClusterInvalidator redisClusterInvalidator = RedisClusterInvalidator.this;
                        synchronized (redisClusterInvalidator) {
                            RedisClusterInvalidator.this.receivedInvals.add(invals);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)("Fail to read message: " + message), (Throwable)e);
                    }
                }
            }, new String[]{this.getChannelName()});
            return null;
        });
    }

    protected String getChannelName() {
        return this.namespace + INVALIDATION_CHANNEL;
    }

    protected void registerNode() {
        this.startedDateTime = this.getCurrentDateTime();
        log.info((Object)("Registering node: " + this.nodeId));
        this.redisExecutor.execute(jedis -> {
            String key = this.getNodeKey();
            Pipeline pipe = jedis.pipelined();
            pipe.hset(key, STARTED_KEY, this.startedDateTime);
            pipe.expire(key, 86400);
            pipe.sync();
            return null;
        });
    }

    protected String getNodeKey() {
        return this.namespace + CLUSTER_NODES_KEY + ":" + this.nodeId;
    }

    public void close() {
        log.debug((Object)"Closing");
        this.unsubscribeToInvalidationChannel();
        this.receivedInvals.clear();
    }

    protected void unsubscribeToInvalidationChannel() {
        this.subscriberThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invalidations receiveInvalidations() {
        Invalidations ret;
        Invalidations newInvals = new Invalidations();
        RedisClusterInvalidator redisClusterInvalidator = this;
        synchronized (redisClusterInvalidator) {
            ret = this.receivedInvals;
            this.receivedInvals = newInvals;
        }
        return ret;
    }

    public void sendInvalidations(Invalidations invals) {
        this.redisExecutor.execute(jedis -> {
            RedisInvalidations rInvals = new RedisInvalidations(this.nodeId, invals);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sending invalidations: " + rInvals));
            }
            String key = this.getNodeKey();
            try {
                Pipeline pipe = jedis.pipelined();
                pipe.publish(this.getChannelName(), rInvals.serialize());
                pipe.hset(key, STARTED_KEY, this.startedDateTime);
                pipe.hset(key, LAST_INVAL_KEY, this.getCurrentDateTime());
                pipe.expire(key, 86400);
                pipe.sync();
                return null;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        });
    }

    protected String getCurrentDateTime() {
        return LocalDateTime.now().toString();
    }
}

