/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.core.io.download.DownloadService;

public class DownloadHelper {
    private static final Log log = LogFactory.getLog(DownloadHelper.class);
    public static final String INLINE = "inline";
    private static final String CLIENT_ABORT_EXCEPTION = "ClientAbortException";
    private static final String EOF_EXCEPTION = "EofException";

    private DownloadHelper() {
    }

    public static DownloadService.ByteRange parseRange(String range, long length) {
        try {
            if (!range.startsWith("bytes=") || range.indexOf(44) >= 0) {
                return null;
            }
            int i = range.indexOf(45, 6);
            if (i < 0) {
                return null;
            }
            String start = range.substring(6, i).trim();
            String end = range.substring(i + 1).trim();
            long rangeStart = 0L;
            long rangeEnd = length - 1L;
            if (start.isEmpty()) {
                if (end.isEmpty()) {
                    return null;
                }
                rangeStart = length - (long)Integer.parseInt(end);
                if (rangeStart < 0L) {
                    rangeStart = 0L;
                }
            } else {
                rangeStart = Integer.parseInt(start);
                if (!end.isEmpty()) {
                    rangeEnd = Integer.parseInt(end);
                }
            }
            if (rangeStart > rangeEnd) {
                return null;
            }
            return new DownloadService.ByteRange(rangeStart, rangeEnd);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getRFC2231ContentDisposition(HttpServletRequest request, String filename) {
        return DownloadHelper.getRFC2231ContentDisposition(request, filename, null);
    }

    public static String getRFC2231ContentDisposition(HttpServletRequest request, String filename, Boolean inline) {
        boolean binline;
        String userAgent = request.getHeader("User-Agent");
        if (inline == null) {
            String inlineParam = request.getParameter(INLINE);
            if (inlineParam == null) {
                inlineParam = (String)request.getAttribute(INLINE);
            }
            binline = inlineParam != null && !"false".equals(inlineParam);
        } else {
            binline = inline;
        }
        return RFC2231.encodeContentDisposition((String)filename, (boolean)binline, (String)userAgent);
    }

    public static boolean isClientAbortError(Throwable t) {
        for (int loops = 20; t != null && loops > 0; --loops, t = t.getCause()) {
            String name;
            if (!(t instanceof IOException) || !CLIENT_ABORT_EXCEPTION.equals(name = t.getClass().getSimpleName()) && !EOF_EXCEPTION.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void logClientAbort(Exception e) {
        log.debug((Object)("Client disconnected: " + DownloadHelper.unwrapException(e).getMessage()));
    }

    private static Throwable unwrapException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static void handleClientDisconnect(IOException e) throws IOException {
        if (!DownloadHelper.isClientAbortError(e)) {
            throw e;
        }
        DownloadHelper.logClientAbort(e);
    }
}

