/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadPermissionDescriptor;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class DownloadServiceImpl
extends DefaultComponent
implements DownloadService {
    private static final Log log = LogFactory.getLog(DownloadServiceImpl.class);
    protected static final int DOWNLOAD_BUFFER_SIZE = 524288;
    private static final String NUXEO_VIRTUAL_HOST = "nuxeo-virtual-host";
    private static final String VH_PARAM = "nuxeo.virtual.host";
    private static final String FORCE_NO_CACHE_ON_MSIE = "org.nuxeo.download.force.nocache.msie";
    private static final String XP = "permissions";
    private static final String RUN_FUNCTION = "run";
    private DownloadPermissionRegistry registry = new DownloadPermissionRegistry();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP.equals(extensionPoint)) {
            throw new UnsupportedOperationException(extensionPoint);
        }
        DownloadPermissionDescriptor descriptor = (DownloadPermissionDescriptor)contribution;
        this.registry.addContribution(descriptor);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DownloadPermissionDescriptor descriptor = (DownloadPermissionDescriptor)contribution;
        this.registry.removeContribution(descriptor);
    }

    @Override
    public String getDownloadUrl(DocumentModel doc, String xpath, String filename) {
        return this.getDownloadUrl(doc.getRepositoryName(), doc.getId(), xpath, filename);
    }

    @Override
    public String getDownloadUrl(String repositoryName, String docId, String xpath, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("nxfile");
        sb.append("/");
        sb.append(repositoryName);
        sb.append("/");
        sb.append(docId);
        if (xpath != null) {
            sb.append("/");
            sb.append(xpath);
            if (filename != null) {
                sb.append("/");
                sb.append(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
            }
        }
        return sb.toString();
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason) throws IOException {
        this.downloadBlob(request, response, doc, xpath, blob, filename, reason, null);
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos) throws IOException {
        if (blob == null) {
            if (doc == null || xpath == null) {
                throw new NuxeoException("No blob or doc xpath");
            }
            blob = this.resolveBlob(doc, xpath);
            if (blob == null) {
                response.sendError(404, "No blob found");
                return;
            }
        }
        Blob fblob = blob;
        this.downloadBlob(request, response, doc, xpath, blob, filename, reason, extendedInfos, null, byteRange -> this.transferBlobWithByteRange(fblob, (DownloadService.ByteRange)byteRange, response));
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline, Consumer<DownloadService.ByteRange> blobTransferer) throws IOException {
        URI uri;
        Objects.requireNonNull(blob);
        if (!this.checkPermission(doc, xpath, blob, reason, extendedInfos)) {
            response.sendError(403, "Permission denied");
            return;
        }
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        URI uRI = uri = blobManager == null ? null : blobManager.getURI(blob, BlobManager.UsageHint.DOWNLOAD, request);
        if (uri != null) {
            try {
                HashMap<String, Serializable> ei = new HashMap<String, Serializable>();
                if (extendedInfos != null) {
                    ei.putAll(extendedInfos);
                }
                ei.put("redirect", (Serializable)((Object)uri.toString()));
                this.logDownload(doc, xpath, filename, reason, ei);
                response.sendRedirect(uri.toString());
            }
            catch (IOException ioe) {
                DownloadHelper.handleClientDisconnect(ioe);
            }
            return;
        }
        try {
            long contentLength;
            DownloadService.ByteRange byteRange;
            String etag = '\"' + blob.getDigest() + '\"';
            response.setHeader("ETag", etag);
            this.addCacheControlHeaders(request, response);
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null) {
                boolean match = false;
                if (ifNoneMatch.equals("*")) {
                    match = true;
                } else {
                    for (String previousEtag : StringUtils.split((String)ifNoneMatch, (String)", ")) {
                        if (!previousEtag.equals(etag)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    String method = request.getMethod();
                    if (method.equals("GET") || method.equals("HEAD")) {
                        response.sendError(304);
                    } else {
                        response.sendError(412);
                    }
                    return;
                }
            }
            if (StringUtils.isBlank((String)filename)) {
                filename = StringUtils.defaultIfBlank((String)blob.getFilename(), (String)"file");
            }
            String contentDisposition = DownloadHelper.getRFC2231ContentDisposition(request, filename, inline);
            response.setHeader("Content-Disposition", contentDisposition);
            response.setContentType(blob.getMimeType());
            if (blob.getEncoding() != null) {
                response.setCharacterEncoding(blob.getEncoding());
            }
            long length = blob.getLength();
            response.setHeader("Accept-Ranges", "bytes");
            String range = request.getHeader("Range");
            if (StringUtils.isBlank((String)range)) {
                byteRange = null;
            } else {
                byteRange = DownloadHelper.parseRange(range, length);
                if (byteRange == null) {
                    log.error((Object)("Invalid byte range received: " + range));
                } else {
                    response.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + length);
                    response.setStatus(206);
                }
            }
            long l = contentLength = byteRange == null ? length : byteRange.getLength();
            if (contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            }
            this.logDownload(doc, xpath, filename, reason, extendedInfos);
            blobTransferer.accept(byteRange);
        }
        catch (UncheckedIOException e) {
            DownloadHelper.handleClientDisconnect(e.getCause());
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect(ioe);
        }
    }

    protected void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, HttpServletResponse response) throws UncheckedIOException {
        this.transferBlobWithByteRange(blob, byteRange, () -> {
            try {
                return response.getOutputStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, Supplier<OutputStream> outputStreamSupplier) throws UncheckedIOException {
        try (InputStream in = blob.getStream();){
            OutputStream out = outputStreamSupplier.get();
            BufferingServletOutputStream.stopBuffering(out);
            if (byteRange == null) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)byteRange.getStart(), (long)byteRange.getLength());
            }
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String fixXPath(String xpath) {
        return xpath == null ? null : xpath.replace(';', ':');
    }

    @Override
    public Blob resolveBlob(DocumentModel doc, String xpath) {
        Blob blob;
        if ((xpath = this.fixXPath(xpath)).startsWith("blobholder:")) {
            int index;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                log.debug((Object)"Not a BlobHolder");
                return null;
            }
            String suffix = xpath.substring("blobholder:".length());
            try {
                index = Integer.parseInt(suffix);
            }
            catch (NumberFormatException e) {
                log.debug((Object)e.getMessage());
                return null;
            }
            if (!suffix.equals(Integer.toString(index))) {
                log.debug((Object)("Non-canonical index: " + suffix));
                return null;
            }
            blob = index == 0 ? bh.getBlob() : (Blob)bh.getBlobs().get(index);
        } else {
            if (!xpath.contains(":")) {
                log.debug((Object)("Non-canonical xpath: " + xpath));
                return null;
            }
            try {
                blob = (Blob)doc.getPropertyValue(xpath);
            }
            catch (PropertyNotFoundException e) {
                log.debug((Object)e.getMessage());
                return null;
            }
        }
        return blob;
    }

    @Override
    public boolean checkPermission(DocumentModel doc, String xpath, Blob blob, String reason, Map<String, Serializable> extendedInfos) {
        List<DownloadPermissionDescriptor> descriptors = this.registry.getDownloadPermissionDescriptors();
        if (descriptors.isEmpty()) {
            return true;
        }
        xpath = this.fixXPath(xpath);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<Object, Object> ei = extendedInfos == null ? Collections.emptyMap() : extendedInfos;
        NuxeoPrincipal currentUser = ClientLoginModule.getCurrentPrincipal();
        context.put("Document", doc);
        context.put("XPath", xpath);
        context.put("Blob", blob);
        context.put("Reason", reason);
        context.put("Infos", ei);
        context.put("Rendition", ei.get("rendition"));
        context.put("CurrentUser", currentUser);
        for (DownloadPermissionDescriptor descriptor : descriptors) {
            Object result;
            ScriptEngine engine = this.scriptEngineManager.getEngineByName(descriptor.getScriptLanguage());
            if (engine == null) {
                throw new NuxeoException("Engine not found for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.getName());
            }
            if (!(engine instanceof Invocable)) {
                throw new NuxeoException("Engine " + engine.getClass().getName() + " not Invocable for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.getName());
            }
            try {
                engine.eval(descriptor.getScript());
                engine.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
                result = ((Invocable)((Object)engine)).invokeFunction(RUN_FUNCTION, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new NuxeoException("Script does not contain function: run() in permission: " + descriptor.getName(), (Throwable)e);
            }
            catch (ScriptException e) {
                log.error((Object)("Failed to evaluate script: " + descriptor.getName()), (Throwable)e);
                continue;
            }
            if (!(result instanceof Boolean)) {
                log.error((Object)("Failed to get boolean result from permission: " + descriptor.getName() + " (" + result + ")"));
                continue;
            }
            boolean allow = (Boolean)result;
            if (allow) continue;
            return false;
        }
        return true;
    }

    protected void addCacheControlHeaders(HttpServletRequest request, HttpServletResponse response) {
        String cacheControl;
        String userAgent = request.getHeader("User-Agent");
        boolean secure = request.isSecure();
        if (!secure) {
            String nvh = request.getHeader(NUXEO_VIRTUAL_HOST);
            if (nvh == null) {
                nvh = Framework.getProperty((String)VH_PARAM);
            }
            if (nvh != null) {
                secure = nvh.startsWith("https");
            }
        }
        if (userAgent != null && userAgent.contains("MSIE") && (secure || DownloadServiceImpl.forceNoCacheOnMSIE())) {
            cacheControl = "max-age=15, must-revalidate";
        } else {
            cacheControl = "private, must-revalidate";
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
        log.debug((Object)("Setting Cache-Control: " + cacheControl));
        response.setHeader("Cache-Control", cacheControl);
    }

    protected static boolean forceNoCacheOnMSIE() {
        return Framework.isBooleanPropertyTrue((String)FORCE_NO_CACHE_ON_MSIE);
    }

    @Override
    public void logDownload(DocumentModel doc, String xpath, String filename, String reason, Map<String, Serializable> extendedInfos) {
        EventContextImpl ctx;
        EventService eventService = (EventService)Framework.getService(EventService.class);
        if (eventService == null) {
            return;
        }
        if (doc != null) {
            CoreSession session = doc.getCoreSession();
            Object principal = session == null ? DownloadServiceImpl.getPrincipal() : session.getPrincipal();
            ctx = new DocumentEventContext(session, (Principal)principal, doc);
            ctx.setProperty("repositoryName", (Serializable)((Object)doc.getRepositoryName()));
            ctx.setProperty("sessionId", (Serializable)((Object)doc.getSessionId()));
        } else {
            ctx = new EventContextImpl(null, (Principal)DownloadServiceImpl.getPrincipal());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blobXPath", xpath);
        map.put("blobFilename", filename);
        map.put("downloadReason", reason);
        if (extendedInfos != null) {
            map.putAll(extendedInfos);
        }
        ctx.setProperty("extendedInfos", (Serializable)map);
        ctx.setProperty("comment", (Serializable)((Object)filename));
        Event event = ctx.newEvent("download");
        eventService.fireEvent(event);
    }

    protected static NuxeoPrincipal getPrincipal() {
        NuxeoPrincipal principal = ClientLoginModule.getCurrentPrincipal();
        if (principal == null) {
            if (!Framework.isTestModeSet()) {
                throw new NuxeoException("Missing security context, login() not done");
            }
            principal = new SystemPrincipal(null);
        }
        return principal;
    }

    public static class DownloadPermissionRegistry
    extends SimpleContributionRegistry<DownloadPermissionDescriptor> {
        public String getContributionId(DownloadPermissionDescriptor contrib) {
            return contrib.getName();
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public DownloadPermissionDescriptor clone(DownloadPermissionDescriptor orig) {
            return new DownloadPermissionDescriptor(orig);
        }

        public void merge(DownloadPermissionDescriptor src, DownloadPermissionDescriptor dst) {
            dst.merge(src);
        }

        public DownloadPermissionDescriptor getDownloadPermissionDescriptor(String id) {
            return (DownloadPermissionDescriptor)this.getCurrentContribution(id);
        }

        public List<DownloadPermissionDescriptor> getDownloadPermissionDescriptors() {
            ArrayList<DownloadPermissionDescriptor> descriptors = new ArrayList<DownloadPermissionDescriptor>(this.currentContribs.values());
            Collections.sort(descriptors);
            return descriptors;
        }
    }
}

