/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BasePermissionsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "permissions";
    private final List<String> availablePermissions = Arrays.asList("Read", "Write", "Everything");

    public BasePermissionsJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeArrayFieldStart(NAME);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            for (String permission : this.getPermissionsInSession(document, wrapper.getSession())) {
                jg.writeString(permission);
            }
        }
        jg.writeEndArray();
    }

    private Iterable<String> getPermissionsInSession(final DocumentModel doc, final CoreSession session) {
        final Principal principal = session.getPrincipal();
        return Iterables.filter(this.availablePermissions, (Predicate)new Predicate<String>(){

            public boolean apply(String permission) {
                return session.hasPermission(principal, doc.getRef(), permission);
            }
        });
    }
}

