/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SchemaJsonWriter
extends ExtensibleEntityJsonWriter<Schema> {
    public static final String ENTITY_TYPE = "schema";

    public SchemaJsonWriter() {
        super(ENTITY_TYPE, Schema.class);
    }

    @Override
    protected void writeEntityBody(Schema schema, JsonGenerator jg) throws IOException {
        jg.writeStringField("name", schema.getName());
        String prefix = schema.getNamespace().prefix;
        if (StringUtils.isNotBlank((String)prefix)) {
            jg.writeStringField("prefix", prefix);
        }
        jg.writeObjectFieldStart("fields");
        for (Field field : schema.getFields()) {
            this.writeField(jg, field);
        }
        jg.writeEndObject();
    }

    protected void writeField(JsonGenerator jg, Field field) throws IOException {
        if (!field.getType().isComplexType()) {
            if (field.getType().isListType()) {
                ListType lt = (ListType)field.getType();
                if (lt.getFieldType().isComplexType()) {
                    if (lt.getFieldType().getName().equals("content")) {
                        jg.writeStringField(field.getName().getLocalName(), "blob[]");
                    } else {
                        jg.writeObjectFieldStart(field.getName().getLocalName());
                        jg.writeStringField("type", "complex[]");
                        jg.writeObjectFieldStart("fields");
                        ComplexType cplXType = (ComplexType)lt.getField().getType();
                        for (Field subField : cplXType.getFields()) {
                            this.writeField(jg, subField);
                        }
                        jg.writeEndObject();
                        jg.writeEndObject();
                    }
                } else {
                    Type type = lt.getFieldType();
                    while (!(type instanceof PrimitiveType)) {
                        type = type.getSuperType();
                    }
                    jg.writeStringField(field.getName().getLocalName(), type.getName() + "[]");
                }
            } else {
                Type type = field.getType();
                while (!(type instanceof PrimitiveType)) {
                    type = type.getSuperType();
                }
                jg.writeStringField(field.getName().getLocalName(), type.getName());
            }
        } else if (field.getType().getName().equals("content")) {
            jg.writeStringField(field.getName().getLocalName(), "blob");
        } else {
            jg.writeObjectFieldStart(field.getName().getLocalName());
            ComplexType cplXType = (ComplexType)field.getType();
            jg.writeObjectFieldStart("fields");
            for (Field subField : cplXType.getFields()) {
                this.writeField(jg, subField);
            }
            jg.writeEndObject();
            jg.writeStringField("type", "complex");
            jg.writeEndObject();
        }
    }
}

