/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.validation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ConstraintJsonWriter
extends ExtensibleEntityJsonWriter<Constraint> {
    public static final String ENTITY_TYPE = "validation_constraint";

    public ConstraintJsonWriter() {
        super(ENTITY_TYPE, Constraint.class);
    }

    @Override
    protected void writeEntityBody(Constraint constraint, JsonGenerator jg) throws IOException {
        Constraint.Description description = constraint.getDescription();
        jg.writeStringField("name", description.getName());
        jg.writeObjectFieldStart("parameters");
        for (Map.Entry param : description.getParameters().entrySet()) {
            jg.writeStringField((String)param.getKey(), ((Serializable)param.getValue()).toString());
        }
        jg.writeEndObject();
    }
}

