/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ContentViewRegistry
extends ContributionFragmentRegistry<ContentViewDescriptor> {
    protected static final Log log = LogFactory.getLog(ContentViewRegistry.class);
    protected final Map<String, ContentViewDescriptor> contentViews = new HashMap<String, ContentViewDescriptor>();
    protected final Map<String, Set<String>> contentViewsByFlag = new HashMap<String, Set<String>>();

    public String getContributionId(ContentViewDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ContentViewDescriptor contrib, ContentViewDescriptor newOrigContrib) {
        String name = contrib.getName();
        if (name == null) {
            log.error((Object)"Cannot register content view without a name");
            return;
        }
        if (this.contentViews.containsKey(id)) {
            this.contentViews.remove(id);
            this.removeContentViewFlags(name);
        }
        if (contrib.isEnabled()) {
            this.contentViews.put(name, contrib);
            this.addContentViewFlags(contrib);
            log.info((Object)("Registering content view with name " + id));
        }
    }

    public void contributionRemoved(String id, ContentViewDescriptor origContrib) {
        this.contentViews.remove(id);
        this.removeContentViewFlags(origContrib);
        log.info((Object)("Unregistering content view with name " + id));
    }

    protected void addContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) {
                    items = new LinkedHashSet<String>();
                }
                items.add(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }

    protected void removeContentViewFlags(String contentViewName) {
        for (Set<String> items : this.contentViewsByFlag.values()) {
            if (items == null) continue;
            items.remove(contentViewName);
        }
    }

    protected void removeContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) continue;
                items.remove(name);
            }
        }
    }

    public ContentViewDescriptor clone(ContentViewDescriptor orig) {
        return orig.clone();
    }

    public void merge(ContentViewDescriptor src, ContentViewDescriptor dst) {
        dst.merge(src);
    }

    public ContentViewDescriptor getContentView(String id) {
        return this.contentViews.get(id);
    }

    public boolean hasContentView(String id) {
        return this.contentViews.containsKey(id);
    }

    public Set<String> getContentViewsByFlag(String flag) {
        return this.contentViewsByFlag.get(flag);
    }

    public Set<String> getContentViewNames() {
        return this.contentViews.keySet();
    }

    public Collection<ContentViewDescriptor> getContentViews() {
        return this.contentViews.values();
    }
}

