/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class SnapshotIndexStatus
implements Iterable<SnapshotIndexShardStatus>,
ToXContent {
    private final String index;
    private final Map<Integer, SnapshotIndexShardStatus> indexShards;
    private final SnapshotShardsStats shardsStats;
    private final SnapshotStats stats;

    SnapshotIndexStatus(String index, Collection<SnapshotIndexShardStatus> shards) {
        this.index = index;
        ImmutableMap.Builder<Integer, SnapshotIndexShardStatus> builder = ImmutableMap.builder();
        this.stats = new SnapshotStats();
        for (SnapshotIndexShardStatus shard : shards) {
            builder.put(shard.getShardId(), shard);
            this.stats.add(shard.getStats());
        }
        this.shardsStats = new SnapshotShardsStats(shards);
        this.indexShards = builder.build();
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, SnapshotIndexShardStatus> getShards() {
        return this.indexShards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<SnapshotIndexShardStatus> iterator() {
        return this.indexShards.values().iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
        this.shardsStats.toXContent(builder, params);
        this.stats.toXContent(builder, params);
        builder.startObject(Fields.SHARDS);
        for (SnapshotIndexShardStatus shard : this.indexShards.values()) {
            shard.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");

        Fields() {
        }
    }
}

