/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequestBuilder;
import org.elasticsearch.client.IndicesAdminClient;

public class AnalyzeRequestBuilder
extends SingleCustomOperationRequestBuilder<AnalyzeRequest, AnalyzeResponse, AnalyzeRequestBuilder> {
    public AnalyzeRequestBuilder(IndicesAdminClient indicesClient) {
        super(indicesClient, new AnalyzeRequest());
    }

    public AnalyzeRequestBuilder(IndicesAdminClient indicesClient, String index, String text) {
        super(indicesClient, new AnalyzeRequest(index, text));
    }

    public AnalyzeRequestBuilder setIndex(String index) {
        ((AnalyzeRequest)this.request).index(index);
        return this;
    }

    public AnalyzeRequestBuilder setAnalyzer(String analyzer) {
        ((AnalyzeRequest)this.request).analyzer(analyzer);
        return this;
    }

    public AnalyzeRequestBuilder setField(String field) {
        ((AnalyzeRequest)this.request).field(field);
        return this;
    }

    public AnalyzeRequestBuilder setTokenizer(String tokenizer) {
        ((AnalyzeRequest)this.request).tokenizer(tokenizer);
        return this;
    }

    public AnalyzeRequestBuilder setTokenFilters(String ... tokenFilters) {
        ((AnalyzeRequest)this.request).tokenFilters(tokenFilters);
        return this;
    }

    public AnalyzeRequestBuilder setCharFilters(String ... charFilters) {
        ((AnalyzeRequest)this.request).charFilters(charFilters);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<AnalyzeResponse> listener) {
        ((IndicesAdminClient)this.client).analyze((AnalyzeRequest)this.request, listener);
    }
}

