/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.custom.TransportSingleCustomOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleCustomOperationAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        @Deprecated
        public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
            return this.paramAsBoolean(key, defaultValue);
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleCustomOperationAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected GetFieldMappingsResponse shardOperation(final GetFieldMappingsIndexRequest request, ShardId shardId) throws ElasticsearchException {
        Collection<String> typeIntersection;
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        if (request.types().length == 0) {
            typeIntersection = indexService.mapperService().types();
        } else {
            typeIntersection = Collections2.filter(indexService.mapperService().types(), new Predicate<String>(){

                @Override
                public boolean apply(String type) {
                    return Regex.simpleMatch(request.types(), type);
                }
            });
            if (typeIntersection.isEmpty()) {
                throw new TypeMissingException(shardId.index(), request.types());
            }
        }
        MapBuilder<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>> typeMappings = new MapBuilder<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>();
        for (String type : typeIntersection) {
            DocumentMapper documentMapper = indexService.mapperService().documentMapper(type);
            ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMapping = this.findFieldMappingsByType(documentMapper, request);
            if (fieldMapping.isEmpty()) continue;
            typeMappings.put(type, fieldMapping);
        }
        return new GetFieldMappingsResponse(ImmutableMap.of(shardId.getIndex(), typeMappings.immutableMap()));
    }

    @Override
    protected GetFieldMappingsIndexRequest newRequest() {
        return new GetFieldMappingsIndexRequest();
    }

    @Override
    protected GetFieldMappingsResponse newResponse() {
        return new GetFieldMappingsResponse();
    }

    private ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData> findFieldMappingsByType(DocumentMapper documentMapper, GetFieldMappingsIndexRequest request) throws ElasticsearchException {
        MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings = new MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData>();
        DocumentFieldMappers allFieldMappers = documentMapper.mappers();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern(field)) {
                for (FieldMapper fieldMapper : allFieldMappers) {
                    this.addFieldMapper(fieldMapper.names().fullName(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                FieldMapper fieldMapper;
                LinkedList remainingFieldMappers = new LinkedList(allFieldMappers);
                Iterator it = remainingFieldMappers.iterator();
                while (it.hasNext()) {
                    fieldMapper = (FieldMapper)it.next();
                    if (!Regex.simpleMatch(field, fieldMapper.names().fullName())) continue;
                    this.addFieldMapper(fieldMapper.names().fullName(), fieldMapper, fieldMappings, request.includeDefaults());
                    it.remove();
                }
                it = remainingFieldMappers.iterator();
                while (it.hasNext()) {
                    fieldMapper = (FieldMapper)it.next();
                    if (!Regex.simpleMatch(field, fieldMapper.names().indexName())) continue;
                    this.addFieldMapper(fieldMapper.names().indexName(), fieldMapper, fieldMappings, request.includeDefaults());
                    it.remove();
                }
                it = remainingFieldMappers.iterator();
                while (it.hasNext()) {
                    fieldMapper = (FieldMapper)it.next();
                    if (!Regex.simpleMatch(field, fieldMapper.names().name())) continue;
                    this.addFieldMapper(fieldMapper.names().name(), fieldMapper, fieldMappings, request.includeDefaults());
                    it.remove();
                }
                continue;
            }
            FieldMapper<?> fieldMapper = allFieldMappers.smartNameFieldMapper(field);
            if (fieldMapper != null) {
                this.addFieldMapper(field, fieldMapper, fieldMappings, request.includeDefaults());
                continue;
            }
            if (!request.probablySingleFieldRequest()) continue;
            fieldMappings.put(field, GetFieldMappingsResponse.FieldMappingMetaData.NULL);
        }
        return fieldMappings.immutableMap();
    }

    private void addFieldMapper(String field, FieldMapper<?> fieldMapper, MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            fieldMapper.toXContent(builder, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS);
            builder.endObject();
            fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetaData(fieldMapper.names().fullName(), builder.bytes()));
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to serialize XContent of field [" + field + "]", e);
        }
    }
}

