/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestRequest;

public class IndicesOptions {
    private static final IndicesOptions[] VALUES;
    private static final byte IGNORE_UNAVAILABLE = 1;
    private static final byte ALLOW_NO_INDICES = 2;
    private static final byte EXPAND_WILDCARDS_OPEN = 4;
    private static final byte EXPAND_WILDCARDS_CLOSED = 8;
    private static final byte FORBID_ALIASES_TO_MULTIPLE_INDICES = 16;
    private static final byte FORBID_CLOSED_INDICES = 32;
    private static final byte STRICT_EXPAND_OPEN = 6;
    private static final byte LENIENT_EXPAND_OPEN = 7;
    private static final byte STRICT_EXPAND_OPEN_CLOSED = 14;
    private static final byte STRICT_EXPAND_OPEN_FORBID_CLOSED = 38;
    private static final byte STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = 48;
    private final byte id;

    private IndicesOptions(byte id) {
        this.id = id;
    }

    public boolean ignoreUnavailable() {
        return (this.id & 1) != 0;
    }

    public boolean allowNoIndices() {
        return (this.id & 2) != 0;
    }

    public boolean expandWildcardsOpen() {
        return (this.id & 4) != 0;
    }

    public boolean expandWildcardsClosed() {
        return (this.id & 8) != 0;
    }

    public boolean forbidClosedIndices() {
        return (this.id & 0x20) != 0;
    }

    public boolean allowAliasesToMultipleIndices() {
        return (this.id & 0x10) == 0;
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_2_2)) {
            out.write(this.id);
        } else if (out.getVersion().before(Version.V_1_2_0)) {
            out.write(this.id & 0xF);
        } else {
            out.write(this.id & 0x1F);
        }
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        byte id = in.readByte();
        if (id >= VALUES.length) {
            throw new ElasticsearchIllegalArgumentException("No valid missing index type id: " + id);
        }
        return VALUES[id];
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, true, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices());
    }

    static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices) {
        byte id = IndicesOptions.toByte(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, allowAliasesToMultipleIndices, forbidClosedIndices);
        return VALUES[id];
    }

    public static IndicesOptions fromRequest(RestRequest request, IndicesOptions defaultSettings) {
        String sWildcards = request.param("expand_wildcards");
        String sIgnoreUnavailable = request.param("ignore_unavailable");
        String sAllowNoIndices = request.param("allow_no_indices");
        if (sWildcards == null && sIgnoreUnavailable == null && sAllowNoIndices == null) {
            return defaultSettings;
        }
        boolean expandWildcardsOpen = false;
        boolean expandWildcardsClosed = false;
        if (sWildcards == null) {
            expandWildcardsOpen = defaultSettings.expandWildcardsOpen();
            expandWildcardsClosed = defaultSettings.expandWildcardsClosed();
        } else {
            String[] wildcards;
            for (String wildcard : wildcards = Strings.splitStringByCommaToArray(sWildcards)) {
                if ("open".equals(wildcard)) {
                    expandWildcardsOpen = true;
                    continue;
                }
                if ("closed".equals(wildcard)) {
                    expandWildcardsClosed = true;
                    continue;
                }
                if ("none".equals(wildcard)) {
                    expandWildcardsOpen = false;
                    expandWildcardsClosed = false;
                    continue;
                }
                if ("all".equals(wildcard)) {
                    expandWildcardsOpen = true;
                    expandWildcardsClosed = true;
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
            }
        }
        return IndicesOptions.fromOptions(IndicesOptions.toBool(sIgnoreUnavailable, defaultSettings.ignoreUnavailable()), IndicesOptions.toBool(sAllowNoIndices, defaultSettings.allowNoIndices()), expandWildcardsOpen, expandWildcardsClosed, defaultSettings.allowAliasesToMultipleIndices(), defaultSettings.forbidClosedIndices());
    }

    @Deprecated
    public static IndicesOptions strict() {
        return IndicesOptions.strictExpandOpen();
    }

    public static IndicesOptions strictExpandOpen() {
        return VALUES[6];
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return VALUES[38];
    }

    public static IndicesOptions strictExpand() {
        return VALUES[14];
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return VALUES[48];
    }

    @Deprecated
    public static IndicesOptions lenient() {
        return IndicesOptions.lenientExpandOpen();
    }

    public static IndicesOptions lenientExpandOpen() {
        return VALUES[7];
    }

    private static byte toByte(boolean ignoreUnavailable, boolean allowNoIndices, boolean wildcardExpandToOpen, boolean wildcardExpandToClosed, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices) {
        byte id = 0;
        if (ignoreUnavailable) {
            id = (byte)(id | 1);
        }
        if (allowNoIndices) {
            id = (byte)(id | 2);
        }
        if (wildcardExpandToOpen) {
            id = (byte)(id | 4);
        }
        if (wildcardExpandToClosed) {
            id = (byte)(id | 8);
        }
        if (!allowAliasesToMultipleIndices) {
            id = (byte)(id | 0x10);
        }
        if (forbidClosedIndices) {
            id = (byte)(id | 0x20);
        }
        return id;
    }

    private static boolean toBool(String sValue, boolean defaultValue) {
        if (sValue == null) {
            return defaultValue;
        }
        return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
    }

    static {
        byte max = 64;
        VALUES = new IndicesOptions[max];
        for (byte id = 0; id < max; id = (byte)(id + 1)) {
            IndicesOptions.VALUES[id] = new IndicesOptions(id);
        }
    }
}

